/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network.http;

import android.content.Context;
import android.text.TextUtils;
import com.taboola.android.global_components.TaboolaContextManager;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.SharedPrefUtil;
import java.net.HttpURLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class HeadersManager {
    private static final String TAG = "HeadersManager";
    private static final String HEADER_DELIMITER = ";";
    private static final String TABOOLA_HEADER = "x-taboola";
    private Context mApplicationContext = TaboolaContextManager.getInstance().getApplicationContext();

    HeadersManager() {
    }

    public synchronized void setHeadersInRequest(HttpURLConnection connection, String trackHeader) {
        HashMap<String, String> taboolaHeaderFields = SharedPrefUtil.getTrackHeadersMap(this.mApplicationContext, trackHeader);
        Logger.d(TAG, "Url = " + connection.getURL() + ", TrackHeader = " + trackHeader + ", setHeadersInRequest: " + Arrays.toString(taboolaHeaderFields.entrySet().toArray()));
        for (Map.Entry entry : taboolaHeaderFields.entrySet()) {
            connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public synchronized void getHeadersFromResponse(HttpURLConnection connection, String trackHeader) {
        Map<String, List<String>> headerFields = connection.getHeaderFields();
        HashMap<String, String> taboolaHeaderFields = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
            String key = entry.getKey();
            if (key == null || !key.toLowerCase().contains(TABOOLA_HEADER)) continue;
            try {
                taboolaHeaderFields.put(key, TextUtils.join((CharSequence)HEADER_DELIMITER, (Iterable)entry.getValue()));
                Logger.d(TAG, "getHeadersFromResponse: " + Arrays.toString(taboolaHeaderFields.entrySet().toArray()));
            }
            catch (Exception e) {
                Logger.e(TAG, "Problem parsing headers. Error: " + e.getLocalizedMessage(), e);
            }
        }
        Logger.d(TAG, "Url = " + connection.getURL() + ", TrackHeader = " + trackHeader + ", getHeadersFromResponse: " + Arrays.toString(taboolaHeaderFields.entrySet().toArray()));
        SharedPrefUtil.setTrackHeadersMap(this.mApplicationContext, taboolaHeaderFields, trackHeader);
    }
}

