/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network.handlers;

import android.os.Bundle;
import android.support.annotation.Keep;
import com.taboola.android.global_components.network.http.HttpManager;
import com.taboola.android.global_components.network.requests.kibana.GlobalExceptionReport;
import com.taboola.android.global_components.network.requests.kibana.IntegrationVerificationFailed;
import com.taboola.android.utils.network.KibanaUtils;

@Keep
public class KibanaHandler {
    private static final String KIBANA_BASE_URL = "https://vidanalytics.taboola.com";
    private static final String KIBANA_MOBILE_SUFFIX = "/putes";
    private static final String KIBANA_INDEX_SUFFIX_SDK_VERIFIER = "/sdk_verifier";
    private static final String KIBANA_INDEX_SUFFIX_GUEH = "/sdk_gueh_exception";
    private HttpManager mHttpManager;

    public void setProtocolManager(HttpManager httpManager) {
        this.mHttpManager = httpManager;
    }

    public void sendVerificationFailedKibanaReport(Bundle bundle, HttpManager.NetworkResponse networkResponse) {
        String sdkVer = "2.2.2-36522-11";
        String timestamp = KibanaUtils.getISO8601currentTime();
        String sdkType = bundle.getString("sdk_type");
        String testName = bundle.getString("test_name");
        boolean isMandatory = bundle.getBoolean("is_mandatory");
        String testOutput = bundle.getString("test_output");
        String publisherId = bundle.getString("publisher_id");
        String sessionId = bundle.getString("session_id");
        IntegrationVerificationFailed integrationVerificationFailed = new IntegrationVerificationFailed(sdkVer, timestamp, sdkType, testName, isMandatory, testOutput, publisherId, sessionId);
        this.mHttpManager.post("https://vidanalytics.taboola.com/putes/sdk_verifier", integrationVerificationFailed.getJsonBody(), null, networkResponse);
    }

    public void sendGUEHExceptionToKibana(GlobalExceptionReport globalExceptionReport, HttpManager.NetworkResponse networkResponse) {
        this.mHttpManager.post("https://vidanalytics.taboola.com/putes/sdk_gueh_exception", globalExceptionReport.getJsonBody(), null, networkResponse);
    }
}

