/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import com.taboola.android.utils.Logger;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class BuildUtils {
    private static final String TAG = BuildUtils.class.getSimpleName();
    private static final String DEBUG_PRINCIPAL_ID = "CN=Android Debug";

    public static boolean isHostAppInDebugMode(Context context) {
        boolean isDebugMode = false;
        try {
            Context applicationContext = context.getApplicationContext();
            PackageInfo packageInfo = applicationContext.getPackageManager().getPackageInfo(context.getPackageName(), 64);
            Signature[] signatures = packageInfo.signatures;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            for (Signature signature : signatures) {
                ByteArrayInputStream stream = new ByteArrayInputStream(signature.toByteArray());
                X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(stream);
                String certificateFlagsString = certificate.getSubjectX500Principal().getName();
                isDebugMode = certificateFlagsString.contains(DEBUG_PRINCIPAL_ID);
                Logger.d(TAG, certificateFlagsString);
                if (!isDebugMode) {
                    continue;
                }
                break;
            }
        }
        catch (NullPointerException e) {
            Logger.d(TAG, e.getLocalizedMessage());
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.d(TAG, e.getLocalizedMessage());
        }
        catch (CertificateException e) {
            Logger.d(TAG, e.getLocalizedMessage());
        }
        return isDebugMode;
    }
}

