package com.taboola.android.js;

import android.content.Context;
import android.support.annotation.Nullable;
import android.webkit.WebView;

import com.taboola.android.api.TaboolaOnClickListener;
import com.taboola.android.utils.Logger;

public interface PublicApi {
    interface PublicTaboolaJs {

        /**
         * Initializes TaboolaJs. Must be called before any other method of the JS SDK.
         * Typically you would want to do it in you Application class in OnCreate()
         *
         * @param applicationContext
         */
        TaboolaJs init(Context applicationContext);

        /**
         * Registers WebView within Taboola JS SDK. WebView must be registered before the page is
         * (re)loaded. {@link android.webkit.JavascriptInterface} with
         * the name declared as {@link TaboolaJs#INJECTED_OBJECT_NAME} will be injected into given WebView
         * <p>
         * Note: When WebView is no longer needed it must be unregistered to avoid leaks</p>
         *
         * @param webView WebView to register
         * @see TaboolaJs#unregisterWebView(WebView)
         */
        TaboolaJs registerWebView(WebView webView);

        /**
         * Registers WebView within Taboola JS SDK. WebView must be registered before the page is
         * (re)loaded. {@link android.webkit.JavascriptInterface} with
         * the name declared as {@link TaboolaJs#INJECTED_OBJECT_NAME} will be injected into given WebView
         * <p>
         * Note: When WebView is no longer needed it must be unregistered to avoid leaks</p>
         *
         * @param webView          WebView to register
         * @param onRenderListener listener to be called when recommendations have succeeded or failed
         *                         to render (called separately for each placement)
         * @see TaboolaJs#unregisterWebView(WebView)
         */
        TaboolaJs registerWebView(WebView webView, OnRenderListener onRenderListener);

        /**
         * Unregisters WebView within Taboola JS SDK. Also, if Android version is HONEYCOMB (Api 11) or higher
         * then previously injected {@link android.webkit.JavascriptInterface} will be removed
         *
         * @param webView WebView to unregister
         * @see TaboolaJs#registerWebView(WebView)
         */
        TaboolaJs unregisterWebView(WebView webView);

        /**
         * Sets log level for the SDK. You can find logLevel constants in the {@link Logger} class, for
         * example Logger.DEBUG
         */
        TaboolaJs setLogLevel(int logLevel);

        /**
         * Registers a listener to be called when recommendations have succeeded or failed to render
         */
        TaboolaJs setOnRenderListener(WebView webView, @Nullable OnRenderListener onRenderListener);

        /**
         * Sdk allows to intercept recommendation clicks, and block default click handling for organic items.
         * If you wand to block the default behavior, and display the recommendation content on your own,
         * return {@code false} in {@link TaboolaOnClickListener#onItemClick(String, String, String, boolean)}
         * <p> Note: The return value will be ignored for non-organic items (!).
         * <p>The listener will be called every time a user clicks a recommendation, right before triggering the default behavior
         */
        TaboolaJs setOnClickListener(TaboolaOnClickListener onClickListener);
    }
}