/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.gueh;

import android.content.Context;
import com.taboola.android.global_components.gueh.SDKExceptionHandler;
import com.taboola.android.global_components.gueh.TaboolaExceptionHandler;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.utils.Logger;
import java.util.ArrayList;

public class GlobalUncaughtExceptionHandler {
    private static final String TAG = GlobalUncaughtExceptionHandler.class.getSimpleName();
    private Thread.UncaughtExceptionHandler mTaboolaGenericExceptionHandler;
    private Thread.UncaughtExceptionHandler mAndroidDefaultHandler;
    private Throwable mLastThrownException;
    private ArrayList<TaboolaExceptionHandler> mTaboolaExceptionHandlerList;

    public GlobalUncaughtExceptionHandler(NetworkManager networkManager, Context context) {
        this.mTaboolaExceptionHandlerList = new ArrayList();
        this.registerExceptionHandler(new SDKExceptionHandler(context, networkManager));
        this.mTaboolaGenericExceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                if (GlobalUncaughtExceptionHandler.this.checkSameException(throwable, GlobalUncaughtExceptionHandler.this.mLastThrownException)) {
                    Logger.d(TAG, "taboolaExceptionHandler | GUEH.start() found current handler to be GUEH, avoiding looping error.");
                    return;
                }
                GlobalUncaughtExceptionHandler.this.mLastThrownException = throwable;
                for (TaboolaExceptionHandler taboolaExceptionHandler : GlobalUncaughtExceptionHandler.this.mTaboolaExceptionHandlerList) {
                    if (!taboolaExceptionHandler.isHandling(throwable)) continue;
                    taboolaExceptionHandler.handle(throwable);
                }
                Logger.d(TAG, "Returning the following exception to prior exception handler: " + throwable.getLocalizedMessage());
                GlobalUncaughtExceptionHandler.this.mAndroidDefaultHandler.uncaughtException(thread, throwable);
            }
        };
    }

    public void registerExceptionHandler(TaboolaExceptionHandler taboolaExceptionHandler) {
        this.mTaboolaExceptionHandlerList.add(taboolaExceptionHandler);
    }

    private boolean checkSameException(Throwable ex, Throwable lastThrownException) {
        if (ex != null && ex.getLocalizedMessage() != null && lastThrownException != null && lastThrownException.getLocalizedMessage() != null) {
            Logger.d(TAG, "Incoming exception is the same as last one thrown in this session. Suspecting cycle, not handling.");
            return ex.getLocalizedMessage().equals(lastThrownException.getLocalizedMessage());
        }
        return false;
    }

    public GlobalUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.mTaboolaGenericExceptionHandler = uncaughtExceptionHandler;
    }

    public void start() {
        Thread.UncaughtExceptionHandler currentUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (this.checkRedundantStart(currentUncaughtExceptionHandler)) {
            Logger.e(TAG, "GlobalUncaughtExceptionHandler | start | redundantStart detected, not setting GUEH.");
            return;
        }
        this.mAndroidDefaultHandler = currentUncaughtExceptionHandler;
        Thread.setDefaultUncaughtExceptionHandler(this.mTaboolaGenericExceptionHandler);
    }

    private boolean checkRedundantStart(Thread.UncaughtExceptionHandler currentUncaughtExceptionHandler) {
        if (currentUncaughtExceptionHandler != null && currentUncaughtExceptionHandler.toString().contains(GlobalUncaughtExceptionHandler.class.getSimpleName())) {
            Logger.d(TAG, "GlobalUncaughtExceptionHandler | start | GUEH.start() found current handler to be GUEH, avoiding looping error.");
            return true;
        }
        return false;
    }

    public void stop() {
        Thread.setDefaultUncaughtExceptionHandler(this.mAndroidDefaultHandler);
    }
}

