/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.widget.ContentLoadingProgressBar;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.taboola.android.R;

public class PopupDialogFragment
extends DialogFragment {
    private static final String TAG = "PopupDialogFragment";
    private static final String URL_PARAM = "PopupDialogFragment.url";
    private ContentLoadingProgressBar mProgressBar;
    private String mUrl;

    static boolean showPopup(FragmentActivity activity, String url) {
        FragmentManager fragmentManager = activity.getSupportFragmentManager();
        Fragment prev = fragmentManager.findFragmentByTag(TAG);
        if (prev != null) {
            fragmentManager.beginTransaction().remove(prev).commitAllowingStateLoss();
        }
        PopupDialogFragment f = new PopupDialogFragment();
        Bundle args = new Bundle();
        args.putString(URL_PARAM, url);
        f.setArguments(args);
        f.show(fragmentManager, TAG);
        return true;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mUrl = this.getArguments().getString(URL_PARAM);
        }
    }

    public void onStart() {
        super.onStart();
        Dialog dialog = this.getDialog();
        if (dialog != null && dialog.getWindow() != null) {
            int width = -1;
            int height = -1;
            dialog.getWindow().setLayout(width, height);
            dialog.setCanceledOnTouchOutside(true);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.dialog_web, container, false);
        this.mProgressBar = (ContentLoadingProgressBar)rootView.findViewById(R.id.web_dialog_progress_bar);
        return rootView;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        final WebView webView = (WebView)view.findViewById(R.id.web_dialog_web_view);
        webView.post(new Runnable(){

            @Override
            public void run() {
                PopupDialogFragment.this.initWebView(webView);
                webView.loadUrl(PopupDialogFragment.this.mUrl);
            }
        });
        view.findViewById(R.id.web_dialog_dismiss_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PopupDialogFragment.this.dismissAllowingStateLoss();
            }
        });
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initWebView(WebView webView) {
        WebSettings settings = webView.getSettings();
        settings.setLoadsImagesAutomatically(true);
        settings.setLoadWithOverviewMode(true);
        settings.setJavaScriptEnabled(true);
        settings.setDomStorageEnabled(true);
        settings.setAppCacheEnabled(true);
        settings.setUseWideViewPort(true);
        if (Build.VERSION.SDK_INT >= 21) {
            CookieManager.getInstance().setAcceptThirdPartyCookies(webView, true);
        }
        settings.setCacheMode(1);
        CookieManager.getInstance().setAcceptCookie(true);
        webView.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                if (PopupDialogFragment.this.mProgressBar != null) {
                    PopupDialogFragment.this.mProgressBar.hide();
                }
            }
        });
    }

    public void onDetach() {
        this.mProgressBar = null;
        super.onDetach();
    }
}

