/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network.http;

import android.os.Looper;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.taboola.android.global_components.network.http.HttpManager;
import com.taboola.android.global_components.network.http.Request;
import com.taboola.android.utils.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

abstract class HttpRequest {
    private int mConfiguredTimeout;

    public HttpRequest(int configuredTimeout) {
        this.mConfiguredTimeout = configuredTimeout;
    }

    void performRequsetOnBackgroundThread(final Request request, final @Nullable HttpManager.NetworkResponse networkResponse) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    HttpRequest.this.performRequest(request, networkResponse);
                }
            }).start();
        } else {
            this.performRequest(request, networkResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performRequest(Request request, @Nullable HttpManager.NetworkResponse networkResponse) {
        String url = request.getUrl();
        HttpURLConnection connection = null;
        try {
            if (url.toLowerCase().contains("https://")) {
                connection = (HttpsURLConnection)new URL(url).openConnection();
            } else if (url.toLowerCase().contains("http://")) {
                connection = (HttpURLConnection)new URL(url).openConnection();
            } else {
                if (networkResponse != null) {
                    networkResponse.onError("url must begin with http:// or https://");
                }
                return;
            }
            connection.setConnectTimeout(this.mConfiguredTimeout);
            connection.setReadTimeout(this.mConfiguredTimeout);
            this.adjustUserAgent(connection);
            this.protocolSpecificConnectionSetup(connection, request);
            connection.connect();
            this.handleResponse(networkResponse, connection);
        }
        catch (NullPointerException e) {
            if (networkResponse != null) {
                networkResponse.onError("NullPointerException: " + e.getLocalizedMessage());
            }
        }
        catch (MalformedURLException e) {
            if (networkResponse != null) {
                networkResponse.onError("MalformedURLException: " + e.getLocalizedMessage());
            }
        }
        catch (IOException e) {
            if (networkResponse != null) {
                networkResponse.onError("IOException: " + e.getLocalizedMessage());
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void adjustUserAgent(HttpURLConnection connection) {
        String USER_AGENT_PROPERTY = "User-Agent";
        String userAgent = connection.getRequestProperty("User-Agent");
        if (!TextUtils.isEmpty((CharSequence)userAgent)) {
            userAgent = StringUtil.removeNonAscii(userAgent);
            connection.setRequestProperty("User-Agent", userAgent);
        }
    }

    abstract void protocolSpecificConnectionSetup(HttpURLConnection var1, Request var2) throws IOException;

    private void handleResponse(@Nullable HttpManager.NetworkResponse networkResponse, HttpURLConnection connection) throws IOException {
        int status = connection.getResponseCode();
        switch (status) {
            case 200: 
            case 201: {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    response.append(line).append("\n");
                }
                br.close();
                if (networkResponse == null) break;
                networkResponse.onResponse(response.toString());
                break;
            }
            default: {
                if (networkResponse == null) break;
                networkResponse.onError("Invalid response code: " + status);
            }
        }
    }
}

