/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network.dynamic_url;

import android.net.Uri;
import android.support.annotation.NonNull;
import com.taboola.android.global_components.network.url_components.PathParam;
import com.taboola.android.global_components.network.url_components.UrlParameters;

public class DynamicUrl {
    private static final String TAG = DynamicUrl.class.getSimpleName();
    private static final String STRUCTURE = "%s%s";
    private static final boolean UTF8_BY_DEFAULT = true;
    private String mBaseUrl;
    private UrlParameters mQueryParameters;

    public DynamicUrl(@NonNull String baseUrl) {
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        this.mBaseUrl = baseUrl;
    }

    public DynamicUrl addQueryParams(UrlParameters queryParameters) {
        this.mQueryParameters = queryParameters;
        return this;
    }

    private String getQueryParams() {
        if (this.mQueryParameters == null || this.mQueryParameters.isEmpty()) {
            return "";
        }
        return "?" + this.mQueryParameters.getString(true);
    }

    public String getUrl() {
        return String.format(STRUCTURE, this.mBaseUrl, this.getQueryParams());
    }

    public String getUrl(PathParam ... pathParams) {
        return String.format(STRUCTURE, this.getBaseUrl(pathParams), this.getQueryParams());
    }

    private String getBaseUrl(PathParam[] pathParams) {
        String baseUrl = this.mBaseUrl;
        for (PathParam pathParam : pathParams) {
            baseUrl = baseUrl.replace(pathParam.getOldVal(), Uri.encode((String)pathParam.getNewVal()));
        }
        return baseUrl;
    }
}

