/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network.dynamic_url;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.global_components.network.dynamic_url.GET;
import com.taboola.android.global_components.network.dynamic_url.POST;
import com.taboola.android.global_components.network.dynamic_url.REQUEST_TYPE;
import com.taboola.android.global_components.network.dynamic_url.annotations.Body;
import com.taboola.android.global_components.network.dynamic_url.annotations.Path;
import com.taboola.android.global_components.network.dynamic_url.annotations.Query;
import com.taboola.android.global_components.network.dynamic_url.annotations.QueryMap;
import com.taboola.android.global_components.network.handlers.GenericHandler;
import com.taboola.android.global_components.network.http.HttpManager;
import com.taboola.android.global_components.network.url_components.MutableUrl;
import com.taboola.android.global_components.network.url_components.PathParam;
import com.taboola.android.global_components.network.url_components.UrlParameter;
import com.taboola.android.utils.Logger;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.json.JSONObject;

public class DynamicRequest {
    private static final String TAG = DynamicRequest.class.getSimpleName();
    private NetworkManager mNetworkManager;
    private String mUrlString;
    private int mRequestType;
    private JSONObject mJsonBody;

    DynamicRequest(NetworkManager networkManager, Method method, Object[] args) {
        this.mNetworkManager = networkManager;
        this.buildRequest(method, args);
    }

    public void execute() {
        this.execute(null);
    }

    public void execute(@Nullable HttpManager.NetworkResponse networkResponse) {
        GenericHandler genericHandler = this.mNetworkManager.getGenericHandler();
        switch (this.mRequestType) {
            case 0: {
                genericHandler.get(this.mUrlString, networkResponse);
                break;
            }
            case 1: {
                genericHandler.post(this.mUrlString, this.mJsonBody, networkResponse);
                break;
            }
            default: {
                Logger.e(TAG, "Error processing method, methodType unrecognized");
            }
        }
    }

    public String getFinalUrl() {
        return this.mUrlString;
    }

    public JSONObject getJsonBody() {
        return this.mJsonBody;
    }

    private void buildRequest(Method method, Object[] args) {
        this.mRequestType = this.getRequestType(method);
        String baseUrl = this.getBaseUrl(method);
        this.mUrlString = this.buildFinalUrl(baseUrl, method, args);
    }

    private String buildFinalUrl(String baseUrl, Method method, Object[] args) {
        MutableUrl mutableUrl = new MutableUrl(baseUrl);
        Annotation[][] perParametersAnnotations = method.getParameterAnnotations();
        if (perParametersAnnotations != null) {
            for (int parameter = 0; parameter < perParametersAnnotations.length; ++parameter) {
                for (int annotation = 0; annotation < perParametersAnnotations[parameter].length; ++annotation) {
                    Annotation tmpAnnotation = perParametersAnnotations[parameter][annotation];
                    if (tmpAnnotation instanceof Path) {
                        this.handlePathAnnotation(args[parameter], mutableUrl, tmpAnnotation);
                        continue;
                    }
                    if (tmpAnnotation instanceof Query) {
                        this.handleQueryAnnotation(args[parameter], mutableUrl, tmpAnnotation);
                        continue;
                    }
                    if (tmpAnnotation instanceof QueryMap) {
                        this.handleQueryMapAnnotation(args[parameter], mutableUrl);
                        continue;
                    }
                    if (tmpAnnotation instanceof Body) {
                        this.handleBodyAnnotation(args[parameter]);
                        continue;
                    }
                    Logger.e(TAG, "Annotation not recognized: " + tmpAnnotation.annotationType());
                }
            }
        }
        String finalUrl = mutableUrl.getUrl();
        Logger.d(TAG, "buildFinalUrl | finalUrl = " + finalUrl);
        return finalUrl;
    }

    private void handlePathAnnotation(Object arg, MutableUrl mutableUrl, Annotation tmpAnnotation) {
        String pathKey = ((Path)tmpAnnotation).value();
        Object pathVal = arg;
        mutableUrl.addPathParam(new PathParam(pathKey, String.valueOf(pathVal)));
    }

    private void handleQueryAnnotation(Object arg, MutableUrl mutableUrl, Annotation tmpAnnotation) {
        String queryKey = ((Query)tmpAnnotation).value();
        Object queryVal = arg;
        mutableUrl.addQueryParameter(new UrlParameter(queryKey, queryVal));
    }

    private void handleQueryMapAnnotation(Object arg, MutableUrl mutableUrl) {
        if (!(arg instanceof Map)) {
            throw new RuntimeException("DynamicRequest | buildFinalUrl | @QueryMap parameter type must be Map.");
        }
        Map parameterMap = (Map)arg;
        for (Map.Entry mapParameter : parameterMap.entrySet()) {
            String queryMapParamKey = String.valueOf(mapParameter.getKey());
            String queryMapParamValue = String.valueOf(mapParameter.getValue());
            mutableUrl.addQueryParameter(new UrlParameter(queryMapParamKey, queryMapParamValue));
        }
    }

    private void handleBodyAnnotation(Object arg) {
        if (!(arg instanceof JSONObject)) {
            throw new RuntimeException("DynamicRequest | buildFinalUrl | @Body parameter type must be of type org.json.JSONObject.");
        }
        this.mJsonBody = (JSONObject)arg;
    }

    @NonNull
    @REQUEST_TYPE
    private int getRequestType(Method method) {
        if (method.getAnnotation(GET.class) != null) {
            return 0;
        }
        if (method.getAnnotation(POST.class) != null) {
            return 1;
        }
        throw new RuntimeException("DynamicRequest | getRequestType | Request interface must declare a known network protocol (See REQUEST_TYPE) in method annotation.");
    }

    @NonNull
    private String getBaseUrl(Method method) {
        switch (this.mRequestType) {
            case 0: {
                return method.getAnnotation(GET.class).value();
            }
            case 1: {
                return method.getAnnotation(POST.class).value();
            }
        }
        throw new RuntimeException("DynamicRequest | getBaseUrl | Request interface must declare a known network protocol (See REQUEST_TYPE) in method annotation.");
    }
}

