/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network.handlers;

import android.os.Bundle;
import com.taboola.android.global_components.network.http.HttpManager;
import com.taboola.android.global_components.network.requests.kibana.GlobalExceptionReport;
import com.taboola.android.global_components.network.requests.kibana.IntegrationVerificationFailed;
import com.taboola.android.utils.network.KibanaUtils;

public class KibanaHandler {
    private static final String KIBANA_BASE_URL = "https://vidanalytics.taboola.com";
    private static final String KIBANA_MOBILE_SUFFIX = "/putes";
    private static final String KIBANA_INDEX_SUFFIX_SDK_VERIFIER = "/sdk_verifier";
    private static final String KIBANA_INDEX_SUFFIX_GUEH = "/sdk_gueh_exception";
    private HttpManager httpManager;

    public void setProtocolManager(HttpManager httpManager) {
        this.httpManager = httpManager;
    }

    public void sendVerificationFailedKibanaReport(Bundle bundle, HttpManager.NetworkResponse networkResponse) {
        String sdkVer = "2.1.3-41455-3";
        String timestamp = KibanaUtils.getISO8601currentTime();
        String sdkType = bundle.getString("sdk_type");
        String testName = bundle.getString("test_name");
        boolean isMandatory = bundle.getBoolean("is_mandatory");
        String testOutput = bundle.getString("test_output");
        String publisherId = bundle.getString("publisher_id");
        String sessionId = bundle.getString("session_id");
        IntegrationVerificationFailed integrationVerificationFailed = new IntegrationVerificationFailed(sdkVer, timestamp, sdkType, testName, isMandatory, testOutput, publisherId, sessionId);
        this.httpManager.post("https://vidanalytics.taboola.com/putes/sdk_verifier", integrationVerificationFailed.getJsonBody(), networkResponse);
    }

    public void sendGUEHExceptionToKibana(GlobalExceptionReport globalExceptionReport, HttpManager.NetworkResponse networkResponse) {
        this.httpManager.post("https://vidanalytics.taboola.com/putes/sdk_gueh_exception", globalExceptionReport.getJsonBody(), networkResponse);
    }
}

