/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.outputing;

import android.os.Build;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.integration_verifier.outputing.VerificationOutput;
import com.taboola.android.integration_verifier.outputing.output_channels.ConsoleOutput;
import com.taboola.android.integration_verifier.outputing.output_channels.KibanaOutput;
import com.taboola.android.integration_verifier.outputing.output_channels.handlers.ConsoleOutputHandler;
import com.taboola.android.integration_verifier.outputing.output_channels.handlers.KibanaOutputHandler;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTarget;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTargets;
import java.util.Hashtable;

public class OutputsManager {
    private Hashtable<Integer, VerificationOutput> outputsTable;
    private ConsoleOutputHandler consoleOutputHandler = new ConsoleOutputHandler();
    private KibanaOutputHandler kibanaOutputHandler;

    public OutputsManager(NetworkManager networkManager) {
        this.kibanaOutputHandler = new KibanaOutputHandler(networkManager);
        this.buildOutputsTable();
    }

    private void buildOutputsTable() {
        ConsoleOutput consoleOutput = new ConsoleOutput(2, this.consoleOutputHandler);
        KibanaOutput kibanaOutput = new KibanaOutput(3, this.kibanaOutputHandler);
        this.outputsTable = new Hashtable();
        this.addVerificationOutput(consoleOutput);
        this.addVerificationOutput(kibanaOutput);
    }

    private void addVerificationOutput(VerificationOutput verificationOutput) {
        int key_id = verificationOutput.getId();
        if (Build.VERSION.SDK_INT >= 24) {
            this.outputsTable.putIfAbsent(key_id, verificationOutput);
        } else if (!this.outputsTable.containsKey(key_id)) {
            this.outputsTable.put(key_id, verificationOutput);
        }
    }

    public void executeOutputs(VerificationOutputTargets verificationOutputTargets) {
        if (verificationOutputTargets == null || verificationOutputTargets.isEmpty()) {
            return;
        }
        for (int i = 0; i < verificationOutputTargets.size(); ++i) {
            VerificationOutputTarget VerificationOutputTarget2 = verificationOutputTargets.getVerificationOutputTarget(i);
            this.outputsTable.get(VerificationOutputTarget2.getOutputId()).execute(VerificationOutputTarget2.getBundle());
        }
    }
}

