/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.testing.tests;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taboola.android.integration_verifier.testing.VerificationTest;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTarget;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTargets;
import com.taboola.android.integration_verifier.testing.tests.publisher_config.PublisherConfigParams;
import com.taboola.android.integration_verifier.utility.IVLoggedException;
import com.taboola.android.integration_verifier.utility.IVLogger;
import com.taboola.android.integration_verifier.utility.IntegrationTypeNameParser;

public class PublisherConfigurationVerificationMandatoryTest
extends VerificationTest {
    private static final String TEST_NAME = "PublisherConfigurationVerificationMandatory";
    private static final String ON_FAIL_ERROR_MESSAGE_PREFIX = "PublisherConfigurationVerificationMandatoryTest | The following configuration fields are mandatory and were not detected: ";
    public static final String KEY_CONFIGURATION_PARAMS = "publisherConfigurationTest_key_configuration_params";

    public PublisherConfigurationVerificationMandatoryTest(int id2, boolean isMandatory) {
        super(id2, isMandatory);
    }

    @Override
    public void execute(@Nullable Context context, @Nullable Bundle bundle, @NonNull VerificationTest.TestResults testResults) {
        boolean success = this.isPublisherConfigurationValid((PublisherConfigParams)bundle.getSerializable(KEY_CONFIGURATION_PARAMS));
        if (success) {
            testResults.onSuccess();
        } else {
            testResults.onFail(this.isMandatory());
        }
    }

    private boolean isPublisherConfigurationValid(PublisherConfigParams publisherConfigParams) {
        if (publisherConfigParams == null) {
            throw new IVLoggedException("PublisherConfigurationVerificationMandatoryTest | isPublisherConfigurationValid | PublisherConfigParams object is null.");
        }
        IVLogger.log("PublisherConfigurationVerificationMandatoryTest | isPublisherConfigurationValid | PublisherConfigParams received | " + publisherConfigParams.toString());
        return publisherConfigParams.validateMandatoryParams();
    }

    @Override
    public VerificationOutputTargets getVerificationOutputTargets(@Nullable Bundle bundle) {
        PublisherConfigParams publisherConfigParams = (PublisherConfigParams)bundle.getSerializable(KEY_CONFIGURATION_PARAMS);
        VerificationOutputTargets verificationOutputTargets = new VerificationOutputTargets(new VerificationOutputTarget[0]);
        Bundle consoleBundle = new Bundle();
        if (publisherConfigParams.hasInvalidMandatoryParams()) {
            String failMessage = ON_FAIL_ERROR_MESSAGE_PREFIX + publisherConfigParams.getInvalidParams();
            consoleBundle.putString("consoleOutput_key_log_error_string", failMessage);
            verificationOutputTargets.add(new VerificationOutputTarget(2, consoleBundle));
            verificationOutputTargets.add(new VerificationOutputTarget(3, this.getKibanaBundle(IntegrationTypeNameParser.getNameFor(bundle.getInt("integration_verifier_key_integrationType")), TEST_NAME, failMessage)));
        }
        return verificationOutputTargets;
    }
}

