/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Point;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ScrollingView;
import android.support.v4.view.ViewPager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.Display;
import android.view.View;
import android.view.ViewParent;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import android.widget.ListView;
import android.widget.ScrollView;
import com.taboola.android.monitor.TBSimCodeChange;
import com.taboola.android.utils.AdvertisingIdClient;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.NumberUtils;
import com.taboola.android.utils.PropertiesHashed;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SdkDetailsHelper {
    private static final String TAG = SdkDetailsHelper.class.getSimpleName();
    private static final String SDK_DATA = "sdkd";
    private static final String SDK_TYPE = "sdkt";
    private static final String SDK_VERSION = "sdkv";
    private static final String APP_NAME = "app";
    private static final String APP_VERSION = "appv";
    private static final String APP_ID = "appid";
    private static final String DEVICE_MODEL = "model";
    private static final String LANGUAGES_ROOT = "lng";
    private static final String KEYBOARD_LANGUAGES = "kbd";
    private static final String MAIN_LANGUAGE = "main";
    private static final String LOCALE_LANGUAGE = "locale";
    private static final String SIM_LANGUAGE = "sim";
    private static final String NETWORK_LANGUAGE = "netw";
    private static final String DISPLAY_LANGUAGE = "dsplng";
    private static final String OS = "os";
    private static final String OS_VERSION = "osv";
    private static final String MEDIATED_VIA = "mdtd";
    private static final String NETWORK_TYPE = "net";
    private static final String TOTAL_MEMORY = "mem";
    private static final String SCREEN_SIZE = "scr";
    private static final String WIDTH = "wd";
    private static final String HEIGHT = "ht";
    private static final String LOCATION = "loc";
    private static final String LAT = "lat";
    private static final String LON = "lng";
    private static final String ROOT_KEY = "additional_data";
    private static final String NT_2G = "2g";
    private static final String NT_3G = "3g";
    private static final String NT_4G = "4g";
    private static final String NT_WIFI = "wifi";
    public static final String SDK_TYPE_WIDGET = "Taboola Android SDK";
    public static final String SDK_TYPE_API = "Taboola Android SDK - API";
    public static final String SDK_TYPE_JS = "Taboola Android SDK - JS";
    private static final String ANDROID = "Android";
    public static final String UNDEFINED = "undefined";
    private static String SIM_ISO_CODE = null;
    private static String sApplicationName;

    private SdkDetailsHelper() {
    }

    static String getDefaultBrowser(Context applicationContext) {
        if (applicationContext == null) {
            return "";
        }
        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)"https://"));
        PackageManager packageManager = applicationContext.getPackageManager();
        if (packageManager == null) {
            return "";
        }
        ResolveInfo resolveInfo = packageManager.resolveActivity(browserIntent, 65536);
        if (resolveInfo == null) {
            return "";
        }
        return resolveInfo.loadLabel(packageManager).toString();
    }

    public static HashMap<String, String> createSdkDetailsMap(Context context, @Nullable String mediatedVia, String sdkType) {
        HashMap<String, String> detailsMap = new HashMap<String, String>();
        detailsMap.put(ROOT_KEY, SdkDetailsHelper.createSdkDetailsJSON(context, mediatedVia, sdkType).toString());
        return detailsMap;
    }

    public static String createSdkJsonString(Context context, @Nullable String mediatedVia, String sdkType) {
        return SdkDetailsHelper.createSdkDetailsJSON(context, mediatedVia, sdkType).toString();
    }

    @SuppressLint(value={"MissingPermission"})
    public static JSONObject createSdkDetailsJSON(Context context, @Nullable String mediatedVia, String sdkType) {
        JSONObject sdkDataJsonObject = new JSONObject();
        JSONObject detailsJsonObject = new JSONObject();
        try {
            PackageInfo packageInfo = SdkDetailsHelper.getPackageInfo(context);
            detailsJsonObject.put(SDK_TYPE, (Object)sdkType);
            detailsJsonObject.put(SDK_VERSION, (Object)"2.0.29-38473-6");
            detailsJsonObject.put(APP_NAME, (Object)TextUtils.htmlEncode((String)SdkDetailsHelper.getApplicationName(context)));
            detailsJsonObject.put(APP_VERSION, (Object)packageInfo.versionName);
            detailsJsonObject.put(APP_ID, (Object)packageInfo.packageName);
            detailsJsonObject.put(DEVICE_MODEL, (Object)TextUtils.htmlEncode((String)SdkDetailsHelper.getDeviceName()));
            detailsJsonObject.put("lng", (Object)SdkDetailsHelper.getLanguagesJson(context));
            detailsJsonObject.put(OS, (Object)ANDROID);
            detailsJsonObject.put(OS_VERSION, (Object)Build.VERSION.RELEASE);
            if (mediatedVia != null) {
                detailsJsonObject.put(MEDIATED_VIA, (Object)mediatedVia);
            }
            detailsJsonObject.put(NETWORK_TYPE, (Object)SdkDetailsHelper.getNetworkClass(context));
            detailsJsonObject.put(TOTAL_MEMORY, (Object)SdkDetailsHelper.getMemory(context));
            JSONObject screenSize = new JSONObject();
            Display display = SdkDetailsHelper.getDisplay(context);
            Point displaySize = SdkDetailsHelper.getDisplayPoint(display);
            int width = displaySize.x;
            int height = displaySize.y;
            screenSize.put(WIDTH, width);
            screenSize.put(HEIGHT, height);
            detailsJsonObject.put(SCREEN_SIZE, (Object)screenSize);
            LocationManager locationManager = (LocationManager)context.getApplicationContext().getSystemService("location");
            if (locationManager != null && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0) {
                Location lastKnownLocation = null;
                List providers = locationManager.getProviders(true);
                if (providers != null) {
                    for (String provider : providers) {
                        Location location = locationManager.getLastKnownLocation(provider);
                        if (location == null || lastKnownLocation != null && !(location.getAccuracy() < lastKnownLocation.getAccuracy())) continue;
                        lastKnownLocation = location;
                    }
                }
                if (lastKnownLocation != null) {
                    double lat = lastKnownLocation.getLatitude();
                    double lng = lastKnownLocation.getLongitude();
                    JSONObject location = new JSONObject();
                    location.put(LAT, NumberUtils.formatDouble(lat, 2));
                    location.put("lng", NumberUtils.formatDouble(lng, 2));
                    detailsJsonObject.put(LOCATION, (Object)location);
                    Logger.d(TAG, "location is available");
                } else {
                    Logger.d(TAG, "location is not available");
                }
            } else {
                Logger.d(TAG, "location permission is not granted");
            }
            sdkDataJsonObject.put(SDK_DATA, (Object)detailsJsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sdkDataJsonObject;
    }

    public static JSONObject getBridgeInfo(Context context, @Nullable String mediatedVia, String sdkType) {
        JSONObject bridge = new JSONObject();
        try {
            JSONObject additionalData = (JSONObject)SdkDetailsHelper.createSdkDetailsJSON(context, mediatedVia, sdkType).get(SDK_DATA);
            bridge.put("deviceId", (Object)AdvertisingIdClient.getCachedAdvertisingId(context));
            bridge.put("AppName", additionalData.get(APP_NAME));
            bridge.put("BundleName", additionalData.get(APP_ID));
            bridge.put("SDKVersion", additionalData.get(SDK_VERSION));
            bridge.put("OSVersion", additionalData.get(OS_VERSION));
            bridge.put(DEVICE_MODEL, additionalData.get(DEVICE_MODEL));
            bridge.put("SDKType", additionalData.get(SDK_TYPE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bridge;
    }

    private static JSONObject getLanguagesJson(Context ctx) throws JSONException {
        InputMethodManager imm;
        JSONObject languagesJson = new JSONObject();
        String mainLanguage = Resources.getSystem().getConfiguration().locale.getISO3Language();
        languagesJson.put(MAIN_LANGUAGE, (Object)mainLanguage);
        Locale deviceLocale = Locale.getDefault();
        if (deviceLocale != null) {
            languagesJson.put(LOCALE_LANGUAGE, (Object)deviceLocale);
            languagesJson.put(DISPLAY_LANGUAGE, (Object)deviceLocale.getDisplayLanguage());
        }
        String simCountryIso = SdkDetailsHelper.getSimCountryIso(ctx);
        languagesJson.put(SIM_LANGUAGE, (Object)simCountryIso);
        TelephonyManager tm = (TelephonyManager)ctx.getSystemService("phone");
        if (tm != null) {
            languagesJson.put(NETWORK_LANGUAGE, (Object)tm.getNetworkCountryIso());
        }
        if ((imm = (InputMethodManager)ctx.getSystemService("input_method")) != null) {
            JSONArray keyboardLanguages = new JSONArray();
            List ims = imm.getEnabledInputMethodList();
            for (InputMethodInfo method : ims) {
                List submethods = imm.getEnabledInputMethodSubtypeList(method, true);
                for (InputMethodSubtype submethod : submethods) {
                    if (!submethod.getMode().equals("keyboard")) continue;
                    keyboardLanguages.put((Object)submethod.getLocale());
                }
            }
            languagesJson.put(KEYBOARD_LANGUAGES, (Object)keyboardLanguages);
        }
        return languagesJson;
    }

    private static String getDeviceName() {
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        if (model.startsWith(manufacturer)) {
            return SdkDetailsHelper.capitalize(model);
        }
        return SdkDetailsHelper.capitalize(manufacturer) + " " + model;
    }

    private static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char first = s.charAt(0);
        if (Character.isUpperCase(first)) {
            return s;
        }
        return Character.toUpperCase(first) + s.substring(1);
    }

    private static String getMemory(Context context) {
        ActivityManager actManager = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
        actManager.getMemoryInfo(memInfo);
        return Long.toString(memInfo.totalMem / 1024L);
    }

    @RequiresApi(api=13)
    private static Point getDisplayPoint(Display display) {
        Point size = new Point();
        display.getSize(size);
        return size;
    }

    private static Display getDisplay(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        return windowManager.getDefaultDisplay();
    }

    public static View getParentScrollView(View view) {
        for (ViewParent vp = view.getParent(); vp != null; vp = vp.getParent()) {
            if (!(vp instanceof ScrollView) && !(vp instanceof ScrollingView) && !(vp instanceof ListView)) continue;
            return (View)vp;
        }
        return null;
    }

    public static boolean shouldRemoveFocus(View view) {
        for (ViewParent vp = view.getParent(); vp != null; vp = vp.getParent()) {
            if (!(vp instanceof ScrollingView) && !(vp instanceof ViewPager)) continue;
            return true;
        }
        return false;
    }

    public static int getDisplayHeight(Context context) {
        Display display = SdkDetailsHelper.getDisplay(context);
        Point size = new Point();
        display.getSize(size);
        return size.y;
    }

    public static String getApplicationName(Context context) {
        if (null == sApplicationName) {
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            int stringId = applicationInfo.labelRes;
            sApplicationName = stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : context.getString(stringId);
        }
        return sApplicationName;
    }

    private static PackageInfo getPackageInfo(Context context) throws PackageManager.NameNotFoundException {
        String packageName = context.getPackageName();
        return context.getPackageManager().getPackageInfo(packageName, 0);
    }

    private static String getNetworkClass(Context context) {
        TelephonyManager mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
        int networkType = mTelephonyManager.getNetworkType();
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return NT_2G;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return NT_3G;
            }
            case 13: {
                return NT_4G;
            }
        }
        return NT_WIFI;
    }

    @Nullable
    public static String getSimCountryIso(Context context) {
        if (TextUtils.isEmpty((CharSequence)SIM_ISO_CODE) || UNDEFINED.equalsIgnoreCase(SIM_ISO_CODE)) {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (tm != null) {
                String simCountryIso = tm.getSimCountryIso();
                SIM_ISO_CODE = TextUtils.isEmpty((CharSequence)simCountryIso) ? UNDEFINED : simCountryIso.toLowerCase();
                return SIM_ISO_CODE;
            }
            SIM_ISO_CODE = UNDEFINED;
        }
        return SIM_ISO_CODE;
    }

    public static boolean forceSimCountryCode(String simCode, String password) {
        String keyHash = PropertiesHashed.md5(password).toLowerCase();
        if (!keyHash.equalsIgnoreCase("11c40e426d7db9502e87c014a217785b")) {
            Logger.e(TAG, "forceSimCountryCode wrong password " + password);
            return false;
        }
        SIM_ISO_CODE = simCode;
        return true;
    }

    public static void verifyIfNeededToChangeSimCode(@Nullable TBSimCodeChange codeChange) {
        String simCode = null;
        String password = null;
        if (codeChange != null) {
            simCode = codeChange.getSimCode();
            password = codeChange.getPassword();
        }
        SdkDetailsHelper.forceSimCountryCode(simCode, password);
    }
}

