/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.testing.tests.crawl_urls;

public class CrawlUrlBlacklist {
    private static final String WEB_GOOGLE_PLAY_URL_PART = "play.google.com";
    private static final String IN_APP_GOOGLE_PLAY_URL_PART = "market://details";
    private static final String[] UNWANTED_URL_PARTS = new String[]{"example.com", "play.google.com", "market://details"};
    private static final String DEFAULT_FAIL_MESSAGE = "Crawling url (%s) is blacklisted.";
    private static final String GOOGLE_PLAY_SPECIFIC_MESSAGE = "Google Play page url detected, are you sure you meant to use (%s) as your url?";
    private String failMessage;

    public boolean isUrlInBlackList(String url) {
        for (int i = 0; i < UNWANTED_URL_PARTS.length; ++i) {
            if (!url.toLowerCase().contains(UNWANTED_URL_PARTS[i])) continue;
            this.failMessage = this.isGooglePlayUrl(url) ? String.format(GOOGLE_PLAY_SPECIFIC_MESSAGE, url) : String.format(DEFAULT_FAIL_MESSAGE, url);
            return true;
        }
        return false;
    }

    private boolean isGooglePlayUrl(String url) {
        return url.toLowerCase().contains(WEB_GOOGLE_PLAY_URL_PART) || url.toLowerCase().contains(IN_APP_GOOGLE_PLAY_URL_PART);
    }

    public String getFailMessage() {
        return this.failMessage;
    }
}

