/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.taboola.android.integration_verifier.network.NetworkManager;
import com.taboola.android.integration_verifier.network.VerifierHttpManager;
import com.taboola.android.integration_verifier.network.handlers.BintrayHandler;
import com.taboola.android.integration_verifier.network.handlers.KibanaHandler;
import com.taboola.android.integration_verifier.outputing.OutputsManager;
import com.taboola.android.integration_verifier.requests.VerificationRequest;
import com.taboola.android.integration_verifier.testing.TestsManager;
import com.taboola.android.integration_verifier.testing.VerificationTest;
import com.taboola.android.integration_verifier.utility.IVLoggedException;
import com.taboola.android.integration_verifier.utility.IVLogger;
import com.taboola.android.integration_verifier.utility.SessionData;

public class IntegrationVerifier {
    public static boolean DEBUG_MODE = false;
    private static IntegrationVerifier instance = null;
    private static boolean isEnabled = false;
    private boolean shouldStopOnMandatoryFail = false;
    private Context context;
    private NetworkManager networkManager;
    private TestsManager testsManager;
    private OutputsManager outputsManager;
    private SessionData sessionData = new SessionData();

    public static IntegrationVerifier getInstance() {
        if (instance == null) {
            instance = new IntegrationVerifier();
        }
        return instance;
    }

    private IntegrationVerifier() {
        this.networkManager = new NetworkManager(new VerifierHttpManager(), new KibanaHandler(), new BintrayHandler());
        this.testsManager = new TestsManager(this.networkManager);
        this.outputsManager = new OutputsManager(this.networkManager);
        this.resetToDefaultValues();
    }

    private void resetToDefaultValues() {
        isEnabled = false;
        this.shouldStopOnMandatoryFail = false;
    }

    public void verify(final @NonNull VerificationRequest verificationRequest) {
        for (final int testId : verificationRequest.getTestsIds()) {
            final VerificationTest verificationTest = this.testsManager.getVerificationTest(testId);
            final Bundle verificationRequestBundle = verificationRequest.getBundle();
            final int integrationType = verificationRequestBundle.getInt("integration_verifier_key_integrationType", 0);
            verificationTest.execute(verificationRequest.getContext(), verificationRequestBundle, new VerificationTest.TestResults(){

                @Override
                public void onSuccess() {
                    IntegrationVerifier.this.testsManager.addToStatusReport(integrationType, verificationTest, "Success");
                    IVLogger.log("IntegrationVerifier | verify() | " + verificationTest.getClass().getSimpleName() + " | onSuccess()");
                    if (verificationRequest.isObserved()) {
                        verificationRequest.getVerificationRequestObserver().onSuccess(testId);
                    }
                }

                @Override
                public void onUnavailable() {
                    IntegrationVerifier.this.testsManager.addToStatusReport(integrationType, verificationTest, "Unavailable");
                    IVLogger.log("IntegrationVerifier | verify() | " + verificationTest.getClass().getSimpleName() + " | onUnavailable()");
                    if (verificationRequest.isObserved()) {
                        verificationRequest.getVerificationRequestObserver().onUnavailable(testId);
                    }
                }

                @Override
                public void onFail(boolean isMandatory) {
                    IntegrationVerifier.this.testsManager.addToStatusReport(integrationType, verificationTest, "Fail");
                    IVLogger.log("IntegrationVerifier | verify() | " + verificationTest.getClass().getSimpleName() + " | onFail()");
                    IntegrationVerifier.this.outputsManager.executeOutputs(verificationTest.getVerificationOutputTargets(verificationRequestBundle));
                    if (verificationRequest.isObserved()) {
                        verificationRequest.getVerificationRequestObserver().onFail(testId, isMandatory);
                    }
                    if (!DEBUG_MODE && IntegrationVerifier.this.shouldStopOnMandatoryFail && isMandatory) {
                        isEnabled = false;
                        return;
                    }
                }
            });
        }
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public TestsManager getTestsManager() {
        return this.testsManager;
    }

    public SessionData getSessionData() {
        return this.sessionData;
    }

    public void verifyIntegration(Context context, boolean stopOnMandatoryFail) {
        if (context == null) {
            throw new IVLoggedException("verifyIntegration called with null context, a valid context is required.");
        }
        this.context = context;
        isEnabled = true;
        this.shouldStopOnMandatoryFail = stopOnMandatoryFail;
        this.sessionData.requestFreshSessionId(context);
    }

    public void logStatusReport() {
        this.testsManager.logStatusReport();
    }

    public void clearStatusReport() {
        this.testsManager.clearStatusReport();
    }
}

