/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.testing.tests.init_order;

import android.support.annotation.Nullable;
import com.taboola.android.integration_verifier.testing.tests.init_order.MethodCall;
import com.taboola.android.integration_verifier.testing.tests.init_order.MethodList;
import com.taboola.android.integration_verifier.utility.IVLoggedException;
import com.taboola.android.integration_verifier.utility.IVLogger;
import java.util.ArrayList;

public class MethodCallOrderTracker {
    private MethodList nonInitMethodsCalls = new MethodList();
    private String illegalMethodCalls_STD;
    private String illegalMethodCalls_JS;
    private String illegalMethodCalls_API;
    private String illegalMethodCalls_TEST;

    @Nullable
    public synchronized boolean wasAnyMethodCalledBeforeInit(int integrationType) {
        IVLogger.log("InitFirstVerificationTest | MethodCallOrderTracker | wasAnyMethodCalledBeforeInit() | Scan start! integrationType = " + integrationType);
        StringBuilder stringBuilder = new StringBuilder();
        for (MethodCall methodCall : this.nonInitMethodsCalls) {
            if (methodCall.integrationType != integrationType) continue;
            IVLogger.log("InitFirstVerificationTest | MethodCallOrderTracker | wasAnyMethodCalledBeforeInit() | on init scan found: " + methodCall.name + "integrationType = " + integrationType);
            stringBuilder.append(" Method: ");
            stringBuilder.append(methodCall.name);
        }
        switch (integrationType) {
            case 1: {
                this.illegalMethodCalls_STD = stringBuilder.toString();
                break;
            }
            case 2: {
                this.illegalMethodCalls_JS = stringBuilder.toString();
                break;
            }
            case 3: {
                this.illegalMethodCalls_API = stringBuilder.toString();
                break;
            }
            case -1: {
                this.illegalMethodCalls_TEST = stringBuilder.toString();
                break;
            }
            default: {
                throw new IVLoggedException("InitFirstVerificationTest | MethodCallOrderTracker | wasAnyMethodCalledBeforeInit() | integrationType unknown.");
            }
        }
        return stringBuilder.length() > 0;
    }

    public synchronized String getBeforeInitMethodNames(int integrationType) {
        switch (integrationType) {
            case 1: {
                return this.illegalMethodCalls_STD;
            }
            case 2: {
                return this.illegalMethodCalls_JS;
            }
            case 3: {
                return this.illegalMethodCalls_API;
            }
            case -1: {
                return this.illegalMethodCalls_TEST;
            }
        }
        throw new IVLoggedException("InitFirstVerificationTest | MethodCallOrderTracker | rememberNonInitApiMethodCall() | integrationType unknown.");
    }

    public synchronized void rememberNonInitApiMethodCall(int integrationType, String methodName) {
        IVLogger.log("InitFirstVerificationTest | MethodCallOrderTracker | rememberNonInitApiMethodCall() | integrationType = " + integrationType + ", methodName = " + methodName);
        MethodCall methodCall = new MethodCall(integrationType, methodName);
        if (!this.nonInitMethodsCalls.contains(methodCall)) {
            this.nonInitMethodsCalls.add(methodCall);
        }
    }

    public synchronized void clearTrackedMethods(int integrationType) {
        ArrayList<MethodCall> deleteMethods = new ArrayList<MethodCall>();
        for (MethodCall methodCall : this.nonInitMethodsCalls) {
            if (methodCall.integrationType != integrationType) continue;
            deleteMethods.add(methodCall);
        }
        this.nonInitMethodsCalls.removeAll(deleteMethods);
    }
}

