/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.testing.tests;

import android.content.Context;
import android.os.Bundle;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.taboola.android.integration_verifier.network.NetworkManager;
import com.taboola.android.integration_verifier.network.VerifierHttpManager;
import com.taboola.android.integration_verifier.testing.VerificationTest;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTarget;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTargets;
import com.taboola.android.integration_verifier.utility.IVLogger;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class SdkVersionVerificationTest
extends VerificationTest {
    private static final String ON_FAIL_ERROR_MESSAGE = "SdkVersionVerificationTest | Local SDK Version (%s) is different from online SDK version (%s). Please consider using the latest SDK Version.";
    private static final int EXPECTED_VERSION_ELEMENTS_NUMBER = 3;
    private static final String INTERNET_PERMISSION = "android.permission.INTERNET";
    public static final String VERSION_VERIFICATION_KEY = "Sdk_version_verification_key";
    private NetworkManager networkManager;
    private String localVersion;
    private String onlineVersion;

    public SdkVersionVerificationTest(int id2, boolean isMandatory, NetworkManager networkManager) {
        super(id2, isMandatory);
        this.networkManager = networkManager;
    }

    @Override
    public void execute(@Nullable Context context, @Nullable Bundle bundle, @NonNull VerificationTest.TestResults testResults) {
        if (context == null || context.checkPermission(INTERNET_PERMISSION, Process.myPid(), Process.myUid()) != 0) {
            IVLogger.log("SdkVersionVerificationTest | execute | context is null");
            testResults.onUnavailable();
            return;
        }
        this.localVersion = bundle.getString(VERSION_VERIFICATION_KEY);
        this.isSdkVersionTheLatestPublished(this.localVersion, testResults);
    }

    private void isSdkVersionTheLatestPublished(final String localVersion, final VerificationTest.TestResults testResults) {
        IVLogger.log("SdkVersionVerificationTest | isSdkVersionTheLatestPublished | Starting network call..");
        this.networkManager.getLatestSdkVersion(new VerifierHttpManager.NetworkResponse(){

            @Override
            public void onResponse(String response) {
                IVLogger.log("SdkVersionVerificationTest | isSdkVersionTheLatestPublished | Network response = " + response);
                if (!TextUtils.isEmpty((CharSequence)response)) {
                    try {
                        SdkVersionVerificationTest.this.compareLocalAndOnlineVersions(localVersion, response, testResults);
                    }
                    catch (JSONException e) {
                        IVLogger.log("SdkVersionVerificationTest | isSdkVersionTheLatestPublished | Exception: " + e.getLocalizedMessage());
                        testResults.onUnavailable();
                    }
                } else {
                    testResults.onUnavailable();
                }
            }

            @Override
            public void onError(String onError) {
                IVLogger.log("SdkVersionVerificationTest | isSdkVersionTheLatestPublished | onError = " + onError);
                testResults.onUnavailable();
            }
        });
    }

    private void compareLocalAndOnlineVersions(String localVersion, String response, VerificationTest.TestResults testResults) throws JSONException {
        if (localVersion == null) {
            localVersion = "";
        }
        this.onlineVersion = new JSONObject(response).getString("name");
        IVLogger.log("SdkVersionVerificationTest | isSdkVersionTheLatestPublished | compareLocalAndOnlineVersions | Online version = " + this.onlineVersion + ", Local version = " + localVersion);
        String[] localVersionArr = localVersion.split(Pattern.quote("."));
        String[] onlineVersionArr = this.onlineVersion.split(Pattern.quote("."));
        if (localVersionArr.length != 3 || onlineVersionArr.length != 3) {
            IVLogger.log("SdkVersionVerificationTest | isSdkVersionTheLatestPublished | compareLocalAndOnlineVersions | Unexpected version string representations, stopping test.");
            testResults.onUnavailable();
            return;
        }
        for (int i = 0; i < 3; ++i) {
            if (Integer.valueOf(localVersionArr[i]) < Integer.valueOf(onlineVersionArr[i])) {
                testResults.onFail(this.isMandatory());
                return;
            }
            if (Integer.valueOf(localVersionArr[i]) <= Integer.valueOf(onlineVersionArr[i])) continue;
            IVLogger.log("SdkVersionVerificationTest | isSdkVersionTheLatestPublished | compareLocalAndOnlineVersions | While developing SDK your version might be higher than online version, stopping test.");
            testResults.onUnavailable();
            return;
        }
        testResults.onSuccess();
    }

    @Override
    public VerificationOutputTargets getVerificationOutputTargets(@Nullable Bundle bundle) {
        VerificationOutputTargets verificationOutputTargets = new VerificationOutputTargets(new VerificationOutputTarget[0]);
        Bundle consoleBundle = new Bundle();
        consoleBundle.putString("consoleOutput_key_log_error_string", String.format(ON_FAIL_ERROR_MESSAGE, this.localVersion, this.onlineVersion));
        verificationOutputTargets.add(new VerificationOutputTarget(2, consoleBundle));
        return verificationOutputTargets;
    }
}

