/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.testing.tests;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taboola.android.integration_verifier.testing.VerificationTest;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTarget;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTargets;
import com.taboola.android.integration_verifier.testing.tests.publisher_config.PublisherConfigParams;
import com.taboola.android.integration_verifier.utility.IVLoggedException;
import com.taboola.android.integration_verifier.utility.IVLogger;

public class PublisherConfigurationVerificationOptionalTest
extends VerificationTest {
    private static final String ON_FAIL_WARNING_MESSAGE_PREFIX = "PublisherConfigurationVerificationOptionalTest | The following configuration fields were not detected but you might want to set them: ";
    public static final String KEY_CONFIGURATION_PARAMS = "publisherConfigurationTest_key_configuration_params";

    public PublisherConfigurationVerificationOptionalTest(int id2, boolean isMandatory) {
        super(id2, isMandatory);
    }

    @Override
    public void execute(@Nullable Context context, @Nullable Bundle bundle, @NonNull VerificationTest.TestResults testResults) {
        boolean success = this.isPublisherConfigurationValid((PublisherConfigParams)bundle.getSerializable(KEY_CONFIGURATION_PARAMS));
        if (success) {
            testResults.onSuccess();
        } else {
            testResults.onFail(this.isMandatory());
        }
    }

    private boolean isPublisherConfigurationValid(PublisherConfigParams publisherConfigParams) {
        if (publisherConfigParams == null) {
            throw new IVLoggedException("PublisherConfigurationVerificationOptionalTest | isPublisherConfigurationValid | PublisherConfigParams object is null.");
        }
        IVLogger.log("PublisherConfigurationVerificationOptionalTest | isPublisherConfigurationValid | PublisherConfigParams received | " + publisherConfigParams.toString());
        return publisherConfigParams.validateMissingOptionalParams();
    }

    @Override
    public VerificationOutputTargets getVerificationOutputTargets(@Nullable Bundle bundle) {
        PublisherConfigParams publisherConfigParams = (PublisherConfigParams)bundle.getSerializable(KEY_CONFIGURATION_PARAMS);
        VerificationOutputTargets verificationOutputTargets = new VerificationOutputTargets(new VerificationOutputTarget[0]);
        Bundle consoleBundle = new Bundle();
        if (publisherConfigParams.hasMissingOptionalParams()) {
            consoleBundle.putString("consoleOutput_key_log_warning_string", ON_FAIL_WARNING_MESSAGE_PREFIX + publisherConfigParams.getMissingOptionalParams());
        }
        verificationOutputTargets.add(new VerificationOutputTarget(2, consoleBundle));
        return verificationOutputTargets;
    }
}

