/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.testing.tests;

import android.content.Context;
import android.os.Bundle;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taboola.android.integration_verifier.testing.VerificationTest;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTarget;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTargets;
import com.taboola.android.integration_verifier.utility.IVLogger;
import java.util.ArrayList;

public class PermissionsVerificationTest
extends VerificationTest {
    public static final String KEY_PERMISSIONS_LIST = "permissionsVerification_key_permissions_list";
    public static final String INTERNET_PERMISSION = "android.permission.INTERNET";
    private boolean allPermissionsGranted = true;
    private StringBuilder stringBuilder = new StringBuilder("PermissionsVerificationTest | The following Taboola Permissions were not asked or permission was not granted: ");

    public PermissionsVerificationTest(int id2, boolean isMandatory) {
        super(id2, isMandatory);
    }

    @Override
    public void execute(@Nullable Context context, @Nullable Bundle bundle, @NonNull VerificationTest.TestResults testResults) {
        boolean success = this.areAllTaboolaPermissionsGranted(context, bundle);
        if (success) {
            testResults.onSuccess();
        } else {
            testResults.onFail(this.isMandatory());
        }
    }

    private boolean areAllTaboolaPermissionsGranted(Context context, Bundle bundle) {
        ArrayList permissionsToCheck = bundle.getStringArrayList(KEY_PERMISSIONS_LIST);
        for (String permission2 : permissionsToCheck) {
            if (this.isPermissionGranted(context, permission2)) continue;
            this.allPermissionsGranted = false;
            this.stringBuilder.append(permission2 + " ");
        }
        IVLogger.log("PermissionsVerificationTest | execute() | areAllTaboolaPermissionsGranted() | allPermissionsGranted = " + this.allPermissionsGranted);
        return this.allPermissionsGranted;
    }

    private boolean isPermissionGranted(Context context, String permission2) {
        return context.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
    }

    @Override
    public VerificationOutputTargets getVerificationOutputTargets(@Nullable Bundle bundle) {
        VerificationOutputTargets verificationOutputTargets = new VerificationOutputTargets(new VerificationOutputTarget[0]);
        Bundle consoleBundle = new Bundle();
        consoleBundle.putString("consoleOutput_key_log_error_string", this.stringBuilder.toString());
        verificationOutputTargets.add(new VerificationOutputTarget(2, consoleBundle));
        return verificationOutputTargets;
    }
}

