/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.testing.tests;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taboola.android.integration_verifier.testing.VerificationTest;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTarget;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTargets;
import com.taboola.android.integration_verifier.testing.tests.init_order.MethodCallOrderTracker;
import com.taboola.android.integration_verifier.utility.IVLoggedException;

public class InitFirstVerificationTest
extends VerificationTest {
    private static final String ON_FAIL_ERROR_MESSAGE = "InitFirstVerificationTest | The following methods were executed before init(): ";
    public static final String KEY_INTEGRATION_TYPE = "initFirstTest_key_integrationType";
    private MethodCallOrderTracker methodCallOrderTracker;

    public InitFirstVerificationTest(int id2, boolean isMandatory, MethodCallOrderTracker methodCallOrderTracker) {
        super(id2, isMandatory);
        this.methodCallOrderTracker = methodCallOrderTracker;
    }

    @Override
    public void execute(@Nullable Context context, @Nullable Bundle bundle, @NonNull VerificationTest.TestResults testResults) {
        boolean success;
        boolean bl = success = !this.wasAnyMethodCalledBeforeInit(bundle.getInt(KEY_INTEGRATION_TYPE));
        if (success) {
            testResults.onSuccess();
        } else {
            testResults.onFail(this.isMandatory());
        }
    }

    private boolean wasAnyMethodCalledBeforeInit(int integrationType) {
        if (integrationType == 0) {
            throw new IVLoggedException("InitFirstVerificationTest | execute() | integrationType unknown, please use a known integration value from INTEGRATION_TYPE.");
        }
        return this.methodCallOrderTracker.wasAnyMethodCalledBeforeInit(integrationType);
    }

    @Override
    public VerificationOutputTargets getVerificationOutputTargets(@Nullable Bundle bundle) {
        int integrationType = bundle.getInt(KEY_INTEGRATION_TYPE);
        VerificationOutputTargets verificationOutputTargets = new VerificationOutputTargets(new VerificationOutputTarget[0]);
        Bundle consoleBundle = new Bundle();
        consoleBundle.putString("consoleOutput_key_log_error_string", ON_FAIL_ERROR_MESSAGE + this.methodCallOrderTracker.getBeforeInitMethodNames(integrationType));
        verificationOutputTargets.add(new VerificationOutputTarget(2, consoleBundle));
        return verificationOutputTargets;
    }
}

