/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.requests;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taboola.android.integration_verifier.requests.VerificationRequestObserver;
import com.taboola.android.integration_verifier.testing.TestIDs;
import java.util.ArrayList;

public class VerificationRequest {
    private Context context;
    private int integrationType;
    private Bundle bundle;
    private TestIDs testsIds;
    private VerificationRequestObserver verificationRequestObserver;

    public VerificationRequest(int integrationType, TestIDs testIds) {
        this(integrationType, null, null, testIds);
    }

    public VerificationRequest(int integrationType, Context context, TestIDs testIds) {
        this(integrationType, context, null, testIds);
    }

    public VerificationRequest(int integrationType, Bundle bundle, TestIDs testIds) {
        this(integrationType, null, bundle, testIds);
    }

    public VerificationRequest(int integrationType, @Nullable Context context, @Nullable Bundle bundle, @NonNull TestIDs testIds) {
        if (testIds == null || testIds.isEmpty()) {
            throw new RuntimeException("VerificationRequests must have tests assigned to them.");
        }
        this.integrationType = integrationType;
        this.context = context;
        this.bundle = bundle;
        this.testsIds = testIds;
    }

    public Context getContext() {
        return this.context;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public ArrayList<Integer> getTestsIds() {
        return this.testsIds.getIdsArrayList();
    }

    public void setVerificationRequestObserver(VerificationRequestObserver verificationRequestObserver) {
        this.verificationRequestObserver = verificationRequestObserver;
    }

    public VerificationRequestObserver getVerificationRequestObserver() {
        return this.verificationRequestObserver;
    }

    public boolean isObserved() {
        return this.verificationRequestObserver != null;
    }

    public int getIntegrationType() {
        return this.integrationType;
    }
}

