/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.outputing;

import android.os.Build;
import com.taboola.android.integration_verifier.outputing.VerificationOutput;
import com.taboola.android.integration_verifier.outputing.output_channels.ConsoleOutput;
import com.taboola.android.integration_verifier.outputing.output_channels.handlers.ConsoleOutputHandler;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTarget;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTargets;
import java.util.Hashtable;

public class OutputsManager {
    private Hashtable<Integer, VerificationOutput> outputsTable;
    private ConsoleOutputHandler consoleOutputHandler = new ConsoleOutputHandler();

    public OutputsManager() {
        this.buildOutputsTable();
    }

    private void buildOutputsTable() {
        ConsoleOutput consoleOutput = new ConsoleOutput(2, this.consoleOutputHandler);
        this.outputsTable = new Hashtable();
        this.addVerificationOutput(consoleOutput);
    }

    private void addVerificationOutput(VerificationOutput verificationOutput) {
        int key_id = verificationOutput.getId();
        if (Build.VERSION.SDK_INT >= 24) {
            this.outputsTable.putIfAbsent(key_id, verificationOutput);
        } else if (!this.outputsTable.containsKey(key_id)) {
            this.outputsTable.put(key_id, verificationOutput);
        }
    }

    public void executeOutputs(VerificationOutputTargets verificationOutputTargets) {
        if (verificationOutputTargets == null || verificationOutputTargets.isEmpty()) {
            return;
        }
        for (int i = 0; i < verificationOutputTargets.size(); ++i) {
            VerificationOutputTarget VerificationOutputTarget2 = verificationOutputTargets.getVerificationOutputTarget(i);
            this.outputsTable.get(VerificationOutputTarget2.getOutputId()).execute(VerificationOutputTarget2.getBundle());
        }
    }
}

