/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android;

import android.content.Context;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.WebView;
import com.taboola.android.listeners.ScrollToTopListener;
import com.taboola.android.utils.SdkDetailsHelper;

public class TaboolaWebView
extends WebView {
    public static final float OFFSET_DELTA_X = 1.4f;
    private float mOldPointX = 0.0f;
    private float mOldPointY = 0.0f;
    private float mDeltaY;
    static final int MIN_DISTANCE = 120;
    private final int[] mViewLocation = new int[2];
    private int mTopScrollview = -1;
    protected boolean mShouldInterceptScroll = false;
    protected boolean mEnableHorizontalScroll = false;
    private boolean mScrolledToTop;
    private ScrollToTopListener mScrollTopListener;
    private SimpleOnGestureListener mGestureDetectorListener = new SimpleOnGestureListener();
    private GestureDetector mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)this.mGestureDetectorListener);

    public TaboolaWebView(Context context) {
        super(context);
    }

    public TaboolaWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TaboolaWebView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public boolean isScrolledToTop() {
        return this.mScrolledToTop;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        View scrollviewParent = SdkDetailsHelper.getParentScrollView((View)this);
        if (scrollviewParent != null) {
            int[] loc = new int[2];
            scrollviewParent.getLocationOnScreen(loc);
            this.mTopScrollview = loc[1];
        }
        if (SdkDetailsHelper.shouldRemoveFocus((View)this)) {
            this.setFocusable(false);
        }
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        boolean bl = this.mScrolledToTop = this.getScrollY() == 0;
        if (this.mScrollTopListener != null && this.mScrolledToTop && t - oldt <= 0) {
            this.mScrollTopListener.onTaboolaWidgetOnTop();
        }
        super.onScrollChanged(l, t, oldl, oldt);
    }

    public void registerScrollToTopListener(ScrollToTopListener scrollListener) {
        this.mScrollTopListener = scrollListener;
    }

    public void unregisterScrollToTopListener() {
        this.mScrollTopListener = null;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mShouldInterceptScroll && this.mTopScrollview > -1) {
            this.getLocationOnScreen(this.mViewLocation);
            if (this.mViewLocation[1] <= this.mTopScrollview) {
                boolean horizontalScrolling = false;
                if (this.mEnableHorizontalScroll) {
                    this.mGestureDetector.onTouchEvent(event);
                }
                switch (event.getAction()) {
                    case 0: {
                        this.mOldPointY = event.getY();
                        this.mOldPointX = event.getX();
                        break;
                    }
                    case 2: {
                        this.mDeltaY = this.mOldPointY - event.getY();
                        if (!this.mEnableHorizontalScroll) break;
                        float absDeltaX = Math.abs(this.mOldPointX - event.getX());
                        if (!this.mGestureDetectorListener.isHorizontalSwipeDetected() || !(absDeltaX > 120.0f) || !(absDeltaX >= Math.abs(this.mDeltaY) * 1.4f)) break;
                        horizontalScrolling = true;
                        break;
                    }
                    case 1: {
                        if (this.mEnableHorizontalScroll) {
                            this.requestDisallowInterceptTouchEvent(true);
                        }
                        return super.onTouchEvent(event);
                    }
                    default: {
                        return super.onTouchEvent(event);
                    }
                }
                if (!this.canScrollVertically(-1) && this.mDeltaY < 0.0f || horizontalScrolling) {
                    this.requestDisallowInterceptTouchEvent(false);
                } else {
                    this.requestDisallowInterceptTouchEvent(true);
                }
            }
        }
        return super.onTouchEvent(event);
    }

    private static class SimpleOnGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private boolean mHorizontalSwipeDetected;

        private SimpleOnGestureListener() {
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (e1 == null || e2 == null) {
                return false;
            }
            float angle = (float)Math.toDegrees(Math.atan2(e1.getY() - e2.getY(), e2.getX() - e1.getX()));
            this.mHorizontalSwipeDetected = angle > -45.0f && angle <= 45.0f || angle >= 135.0f && angle < 180.0f || angle < -135.0f && angle > -180.0f;
            return false;
        }

        boolean isHorizontalSwipeDetected() {
            return this.mHorizontalSwipeDetected;
        }
    }
}

