/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.api;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.widget.ImageView;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.squareup.picasso.Callback;
import com.squareup.picasso.RequestCreator;
import com.taboola.android.api.PublicApi;
import com.taboola.android.api.TBImageView;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBPlacementRequest;
import com.taboola.android.api.TBPublisherApi;
import com.taboola.android.api.TBTextView;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.utils.Logger;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TBRecommendationItem
implements PublicApi.PublicTBRecommendationItem,
Parcelable {
    private static final String TAG = TBRecommendationItem.class.getSimpleName();
    private HashMap<String, String> extraDataMap;
    @SerializedName(value="thumbnail")
    @Expose
    private List<Thumbnail> thumbnail = new ArrayList<Thumbnail>();
    @SerializedName(value="name")
    @Expose
    private String name;
    @SerializedName(value="branding")
    @Expose
    private String branding;
    @SerializedName(value="description")
    @Expose
    private String description;
    @SerializedName(value="id")
    @Expose
    private String id;
    @SerializedName(value="url")
    @Expose
    private String url;
    @SerializedName(value="type")
    @Expose
    private String type;
    @SerializedName(value="origin")
    @Expose
    private String origin;
    private String mPublisherId;
    private long onVisibleTimestamp = 0L;
    private boolean wasRecommendationItemVisible = false;
    private transient WeakReference<TBImageView> mThumbnailView;
    private transient WeakReference<TBTextView> mTitleView;
    @Nullable
    private transient WeakReference<TBTextView> mBrandingView;
    @Nullable
    private transient WeakReference<TBTextView> mDescriptionView;
    private transient TBPlacement mPlacement;
    public static final Parcelable.Creator<TBRecommendationItem> CREATOR = new Parcelable.Creator<TBRecommendationItem>(){

        public TBRecommendationItem createFromParcel(Parcel in) {
            return new TBRecommendationItem(in);
        }

        public TBRecommendationItem[] newArray(int size) {
            return new TBRecommendationItem[size];
        }
    };

    protected TBRecommendationItem(Parcel in) {
        Bundle mapsBundle = in.readBundle();
        Serializable dataMap = mapsBundle.getSerializable("extraDataMap");
        this.extraDataMap = (HashMap)dataMap;
        this.thumbnail = in.createTypedArrayList(Thumbnail.CREATOR);
        this.name = in.readString();
        this.mPublisherId = in.readString();
        this.branding = in.readString();
        this.description = in.readString();
        this.id = in.readString();
        this.url = in.readString();
        this.type = in.readString();
        this.origin = in.readString();
        this.onVisibleTimestamp = in.readLong();
        this.wasRecommendationItemVisible = in.readByte() != 0;
    }

    public TBImageView getThumbnailView(Context activityContext, int height, int width) {
        return this.getThumbnailView(activityContext, height, width, null);
    }

    private TBImageView getThumbnailView(Context activityContext, int height, int width, Callback callback) {
        if (this.mThumbnailView != null && this.mThumbnailView.get() != null) {
            return (TBImageView)this.mThumbnailView.get();
        }
        TBImageView tbImageView = new TBImageView(activityContext, this.mPublisherId);
        if (height == 0 || width == 0) {
            Log.w((String)TAG, (String)("getThumbnailView() called with zero width or height:  height = [" + height + "], width = [" + width + "]"));
        }
        tbImageView.setMinimumWidth(width);
        tbImageView.setMinimumHeight(height);
        String imageUrl = this.getImageUrl();
        try {
            imageUrl = this.replaceImageSizeInUrl(height, width);
        }
        catch (Exception e) {
            Logger.e(TAG, "fail to create override url with updated width & height, url = " + imageUrl + ", " + e.toString(), e);
        }
        this.loadImageViewUrl(tbImageView, imageUrl, callback);
        return tbImageView;
    }

    @Override
    @NonNull
    public TBImageView getThumbnailView(Context activityContext) {
        TBPlacementRequest placementRequest;
        if (this.mThumbnailView != null && this.mThumbnailView.get() != null) {
            return (TBImageView)this.mThumbnailView.get();
        }
        TBImageView tbImageView = new TBImageView(activityContext, this.mPublisherId);
        if (this.mPlacement.getNextBatchRequest() != null && (placementRequest = this.mPlacement.getNextBatchRequest().getPlacementRequests().values().iterator().next()) != null) {
            int height = placementRequest.getThumbnailHeight();
            int width = placementRequest.getThumbnailWidth();
            if (height != 0 && width != 0) {
                tbImageView.setMinimumWidth(width);
                tbImageView.setMinimumHeight(height);
            }
        }
        this.loadImageViewUrl(tbImageView, this.getImageUrl(), null);
        return tbImageView;
    }

    private void loadImageViewUrl(TBImageView tbImageView, String url, Callback callback) {
        tbImageView.setAdjustViewBounds(true);
        tbImageView.setRecommendationItem(this);
        if (!TaboolaApi.getInstance(this.mPublisherId).isOverrideImageLoad()) {
            RequestCreator requestCreator = TaboolaApi.getInstance().getPicasso().load(url);
            Drawable placeholder = TaboolaApi.getInstance(this.mPublisherId).getImagePlaceholder();
            if (placeholder != null) {
                requestCreator.placeholder(placeholder);
            }
            if (callback != null) {
                requestCreator.into((ImageView)tbImageView, callback);
            } else {
                requestCreator.into((ImageView)tbImageView);
            }
        }
        this.mThumbnailView = new WeakReference<TBImageView>(tbImageView);
    }

    private String getImageUrl() {
        return this.thumbnail.get(0).getUrl();
    }

    private String replaceImageSizeInUrl(int height, int width) throws UnsupportedEncodingException {
        String url = URLDecoder.decode(this.getImageUrl(), "utf-8");
        String[] split = url.split(",");
        StringBuilder builder = new StringBuilder();
        boolean hasHeight = false;
        boolean hasWidth = false;
        for (int i = 0; i < split.length; ++i) {
            String urlPart = split[i];
            if (urlPart.startsWith("h_")) {
                urlPart = "h_" + height;
                hasHeight = true;
            } else if (urlPart.startsWith("w_")) {
                urlPart = "w_" + width;
                hasWidth = true;
            }
            builder.append(urlPart);
            if (i < split.length - 1) {
                builder.append(",");
            }
            if (hasHeight || hasWidth || i != split.length - 2) continue;
            builder.append("h_").append(height).append(",").append("w_").append(width).append(",");
        }
        return builder.toString();
    }

    @Override
    @NonNull
    public TBTextView getTitleView(Context activityContext) {
        if (this.mTitleView != null && this.mTitleView.get() != null) {
            return (TBTextView)this.mTitleView.get();
        }
        TBTextView tbTextView = new TBTextView(activityContext, this.mPublisherId);
        tbTextView.setRecommendationItem(this);
        tbTextView.setText(this.name);
        tbTextView.setTypeface(Typeface.SANS_SERIF, 1);
        tbTextView.setTextSize(16.0f);
        tbTextView.setTextColor(-16777216);
        this.mTitleView = new WeakReference<TBTextView>(tbTextView);
        return tbTextView;
    }

    @Override
    @Nullable
    public TBTextView getBrandingView(Context activityContext) {
        if (this.mBrandingView != null && this.mBrandingView.get() != null) {
            return (TBTextView)this.mBrandingView.get();
        }
        if (TextUtils.isEmpty((CharSequence)this.branding)) {
            return null;
        }
        TBTextView tbTextView = new TBTextView(activityContext, this.mPublisherId);
        tbTextView.setRecommendationItem(this);
        tbTextView.setText(this.branding);
        tbTextView.setTypeface(Typeface.SANS_SERIF, 1);
        tbTextView.setTextSize(11.0f);
        tbTextView.setTextColor(Color.rgb((int)153, (int)153, (int)153));
        this.mBrandingView = new WeakReference<TBTextView>(tbTextView);
        return tbTextView;
    }

    @Override
    @Nullable
    public TBTextView getDescriptionView(Context activityContext) {
        if (this.mDescriptionView != null && this.mDescriptionView.get() != null) {
            return (TBTextView)this.mDescriptionView.get();
        }
        if (TextUtils.isEmpty((CharSequence)this.description)) {
            return null;
        }
        TBTextView tbTextView = new TBTextView(activityContext, this.mPublisherId);
        tbTextView.setRecommendationItem(this);
        tbTextView.setText(this.description);
        tbTextView.setTypeface(Typeface.SANS_SERIF, 1);
        tbTextView.setTextSize(11.0f);
        tbTextView.setTextColor(Color.rgb((int)153, (int)153, (int)153));
        this.mDescriptionView = new WeakReference<TBTextView>(tbTextView);
        return tbTextView;
    }

    @Override
    public void prefetchThumbnail() {
        TaboolaApi.getInstance().getPicasso().load(this.getImageUrl()).fetch();
    }

    @Override
    public void handleClick(Context activityContext) {
        TaboolaApi.getInstance(this.mPublisherId).onItemClick(activityContext, this.mPlacement.getName(), this.mPlacement.getId(), this.id, this.url, this.isOrganic(), this.type);
    }

    public HashMap<String, String> getExtraDataMap() {
        return this.extraDataMap;
    }

    @MainThread
    public void notifyAvailable() {
        this.onViewAvailable();
    }

    @MainThread
    public void notifyVisible() {
        this.onViewVisible();
    }

    public TBPlacement getPlacement() {
        return this.mPlacement;
    }

    void onViewAvailable() {
        this.mPlacement.onItemAvailable();
    }

    void onViewVisible() {
        Logger.d(TAG, "RecommendationItemVisible: " + this.id);
        if (this.onVisibleTimestamp == 0L) {
            this.onVisibleTimestamp = System.currentTimeMillis();
        }
        this.wasRecommendationItemVisible = true;
        this.mPlacement.onItemVisible();
        this.stopVisibilityCheck();
    }

    void onViewClick(Context context) {
        if (!this.wasRecommendationItemVisible) {
            Logger.d(TAG, "onViewClick: click ignored, because item is not considered visible");
            return;
        }
        TBPublisherApi tbPublisherApi = TaboolaApi.getInstance(this.mPublisherId);
        int onClickIgnoreTimeMs = tbPublisherApi.getOnClickIgnoreTimeMs();
        if (this.onVisibleTimestamp + (long)onClickIgnoreTimeMs < System.currentTimeMillis()) {
            tbPublisherApi.onItemClick(context, this.mPlacement.getName(), this.mPlacement.getId(), this.id, this.url, this.isOrganic(), this.type);
        } else {
            Logger.d(TAG, "onViewClick: click ignored, because item was visible for less than " + onClickIgnoreTimeMs + " ms");
        }
    }

    private void stopVisibilityCheck() {
        if (this.mThumbnailView != null && this.mThumbnailView.get() != null) {
            ((TBImageView)this.mThumbnailView.get()).stopVisibilityCheck();
        }
        if (this.mTitleView != null && this.mTitleView.get() != null) {
            ((TBTextView)this.mTitleView.get()).stopVisibilityCheck();
        }
        if (this.mBrandingView != null && this.mBrandingView.get() != null) {
            ((TBTextView)this.mBrandingView.get()).stopVisibilityCheck();
        }
        if (this.mDescriptionView != null && this.mDescriptionView.get() != null) {
            ((TBTextView)this.mDescriptionView.get()).stopVisibilityCheck();
        }
    }

    void setPlacement(TBPlacement placement) {
        this.mPlacement = placement;
    }

    void setExtraDataMap(HashMap<String, String> extraDataMap) {
        this.extraDataMap = extraDataMap;
    }

    boolean isOrganic() {
        return "organic".equalsIgnoreCase(this.origin);
    }

    void setHighlighted(boolean isHighlighted) {
        int newBackground = isHighlighted ? -16711936 : 0;
        TBImageView imageView = (TBImageView)this.mThumbnailView.get();
        TBTextView titleView = (TBTextView)this.mTitleView.get();
        TBTextView brandingView = (TBTextView)this.mBrandingView.get();
        if (imageView != null) {
            imageView.setBackgroundColor(newBackground);
        }
        if (titleView != null) {
            titleView.setBackgroundColor(newBackground);
        }
        if (brandingView != null) {
            brandingView.setBackgroundColor(newBackground);
        }
    }

    String getPublisherId() {
        return this.mPublisherId;
    }

    void setPublisherId(String publisherId) {
        this.mPublisherId = publisherId;
    }

    @MainThread
    public void reportEvent(String type, Map<String, String> data, String password) {
        if (this.mPlacement != null) {
            this.mPlacement.reportEvent(type, data, password);
        } else {
            TBPublisherApi tbPublisherApi = TaboolaApi.getInstance(this.mPublisherId);
            tbPublisherApi.reportClientEvent(type, data, password, this.id);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle mapsBundle = new Bundle();
        mapsBundle.putSerializable("extraDataMap", this.extraDataMap);
        dest.writeBundle(mapsBundle);
        dest.writeTypedList(this.thumbnail);
        dest.writeString(this.name);
        dest.writeString(this.mPublisherId);
        dest.writeString(this.branding);
        dest.writeString(this.description);
        dest.writeString(this.id);
        dest.writeString(this.url);
        dest.writeString(this.type);
        dest.writeString(this.origin);
        dest.writeLong(this.onVisibleTimestamp);
        dest.writeByte((byte)(this.wasRecommendationItemVisible ? 1 : 0));
    }

    private static class Thumbnail
    implements Parcelable {
        @SerializedName(value="url")
        @Expose
        private String url;
        public static final Parcelable.Creator<Thumbnail> CREATOR = new Parcelable.Creator<Thumbnail>(){

            public Thumbnail createFromParcel(Parcel in) {
                return new Thumbnail(in);
            }

            public Thumbnail[] newArray(int size) {
                return new Thumbnail[size];
            }
        };

        protected Thumbnail(Parcel in) {
            this.url = in.readString();
        }

        String getUrl() {
            return this.url;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.url);
        }
    }
}

