/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.api;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import com.taboola.android.api.PublicApi;
import com.taboola.android.api.SdkVisibilityCheckScheduler;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.VisibilityUtil;

public class TBImageView
extends ImageView
implements PublicApi.PublicTBView {
    private static final String TAG = TBImageView.class.getSimpleName();
    private TBRecommendationItem mRecommendationItem;
    @Nullable
    private SdkVisibilityCheckScheduler mSdkVisibilityCheckScheduler;
    private float mTouchCoordinateY;

    TBImageView(Context context, String publisherId) {
        super(context);
        super.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TBImageView.this.onClick();
            }
        });
        this.mSdkVisibilityCheckScheduler = new SdkVisibilityCheckScheduler((View)this, publisherId);
    }

    @Override
    public void handleClick() {
        this.mRecommendationItem.handleClick(this.getContext());
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        throw new UnsupportedOperationException("To set custom onClick handling use TaboolaSDK.setOnClickListener()");
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mRecommendationItem.onViewAvailable();
        Logger.d(TAG, "onAttachedToWindow: isShown() " + this.isShown());
        if (this.isShown()) {
            this.startVisibilityCheck();
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        Logger.d(TAG, "onVisibilityChanged: isShown() " + this.isShown());
        if (this.isShown()) {
            this.startVisibilityCheck();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopVisibilityCheck();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 1) {
            this.mTouchCoordinateY = event.getY();
        }
        return super.onTouchEvent(event);
    }

    void startVisibilityCheck() {
        if (this.mSdkVisibilityCheckScheduler != null) {
            this.mSdkVisibilityCheckScheduler.startVisibilityMonitoring();
        }
    }

    void stopVisibilityCheck() {
        if (this.mSdkVisibilityCheckScheduler != null) {
            this.mSdkVisibilityCheckScheduler.stopVisibilityMonitoring();
        }
    }

    void checkVisibility() {
        if (this.isVisible()) {
            this.mRecommendationItem.onViewVisible();
            this.stopVisibilityCheck();
            this.mSdkVisibilityCheckScheduler = null;
        }
    }

    private void onClick() {
        int ignoreBorderPx = 22;
        int height = this.getHeight();
        int calculatedIgnoreBorderPx = (int)((double)height * 0.055);
        if (ignoreBorderPx > calculatedIgnoreBorderPx) {
            ignoreBorderPx = calculatedIgnoreBorderPx;
        }
        if (this.mTouchCoordinateY > (float)ignoreBorderPx && this.mTouchCoordinateY < (float)(height - ignoreBorderPx)) {
            this.mRecommendationItem.onViewClick(this.getContext());
        } else {
            Logger.d(TAG, "onClick: click ignored, because click was performed at the very edge of the view");
        }
    }

    private boolean isVisible() {
        int visiblePercent = VisibilityUtil.getVisiblePercent((View)this);
        return visiblePercent >= 50;
    }

    void setRecommendationItem(TBRecommendationItem recommendationItem) {
        this.mRecommendationItem = recommendationItem;
    }
}

