/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.customtabs.CustomTabsIntent;
import com.taboola.android.utils.Logger;
import java.util.List;

public class OnClickHelper {
    public static boolean areChromeCustomTabsSupported(Context context) {
        String CHROME_SERVICE_ACTION = "android.support.customtabs.action.CustomTabsService";
        String CHROME_PACKAGE = "com.android.chrome";
        Intent serviceIntent = new Intent("android.support.customtabs.action.CustomTabsService");
        serviceIntent.setPackage("com.android.chrome");
        List resolveInfos = context.getPackageManager().queryIntentServices(serviceIntent, 0);
        try {
            Class.forName("android.support.customtabs.CustomTabsService");
        }
        catch (ClassNotFoundException e) {
            Logger.d("ContentValues", "areChromeCustomTabsSupported :: ChromeCustomTabs not included in hosting app");
            return false;
        }
        return resolveInfos != null && !resolveInfos.isEmpty();
    }

    public static void openUrlInTabsOrBrowser(Context activityContext, String url) {
        try {
            if (OnClickHelper.areChromeCustomTabsSupported(activityContext)) {
                Logger.d("ContentValues", "openChromeTab :: opening ad in a ChromeTab");
                CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().build();
                customTabsIntent.launchUrl(activityContext, Uri.parse((String)url));
            } else {
                Logger.d("ContentValues", "openNativeBrowser :: opening add");
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                activityContext.startActivity(intent);
            }
        }
        catch (Exception e) {
            Logger.e("ContentValues", "openUrlInTabsOrBrowser :: failed to open url " + e.toString());
        }
    }
}

