/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.js;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.webkit.JavascriptInterface;
import com.taboola.android.api.TaboolaOnClickListener;
import com.taboola.android.js.OnRenderListener;
import com.taboola.android.js.OnResizeListener;
import com.taboola.android.js.TaboolaJs;
import com.taboola.android.js.WebViewManager;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.OnClickHelper;
import com.taboola.android.utils.PopupHelper;
import com.taboola.android.utils.RequestUtil;

class InjectedObject {
    private static final String TAG = InjectedObject.class.getSimpleName();
    private static final String DATA_KEY_PUBLISHER_ID = "DATA_KEY_PUBLISHER_ID";
    private Context mActivityContext;
    private WebViewManager mWebViewManager;
    private Handler mMainHandler;
    private String mPublisherId;

    InjectedObject(Context activityContext, WebViewManager webViewManager) {
        this.mActivityContext = activityContext;
        this.mWebViewManager = webViewManager;
        this.mMainHandler = new Handler(Looper.getMainLooper());
    }

    @JavascriptInterface
    public boolean isAlive() {
        if (this.mWebViewManager != null) {
            Logger.d(TAG, "isAlive: " + this.mWebViewManager.isAlive());
            return this.mWebViewManager.isAlive();
        }
        return false;
    }

    @JavascriptInterface
    public boolean isMonitoringEnabled() {
        return this.mWebViewManager.isSdkMonitorInstalled();
    }

    @JavascriptInterface
    public int getLogLevel() {
        int nativeLogLevel = Logger.getLogLevel();
        int JS_ERROR = 3;
        int JS_WARN = 2;
        boolean JS_INFO = true;
        boolean JS_DEBUG = false;
        switch (nativeLogLevel) {
            case 6: {
                return 3;
            }
            case 5: {
                return 2;
            }
            case 4: {
                return 1;
            }
            case 3: {
                return 0;
            }
            case 2: {
                return 0;
            }
        }
        return 3;
    }

    @JavascriptInterface
    public String getExternalRects() {
        return this.mWebViewManager.getVisibleBounds();
    }

    @JavascriptInterface
    public String getDeviceData() {
        return this.mWebViewManager.getDeviceData();
    }

    @JavascriptInterface
    public void onPlacementResize(final String placementName, final int height) {
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                OnResizeListener listener = InjectedObject.this.mWebViewManager.getOnResizeListener();
                if (listener != null) {
                    listener.onResize(InjectedObject.this.mWebViewManager.getWebView(), placementName, height);
                }
            }
        });
    }

    @JavascriptInterface
    public void onRenderSuccess(final String placementName, final int height) {
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                OnRenderListener onRenderListener;
                String func = String.format("%1$s.onDataRetrieved(\"%2$s\", taboolaMobile.getPublisherId())", "taboolaNative", InjectedObject.DATA_KEY_PUBLISHER_ID);
                InjectedObject.this.mWebViewManager.callJsFunction(func);
                InjectedObject.this.mWebViewManager.setDidRender(true);
                OnResizeListener listener = InjectedObject.this.mWebViewManager.getOnResizeListener();
                if (listener != null) {
                    listener.onResize(InjectedObject.this.mWebViewManager.getWebView(), placementName, height);
                }
                if ((onRenderListener = InjectedObject.this.mWebViewManager.getOnRenderListener()) != null) {
                    onRenderListener.onRenderSuccessful(InjectedObject.this.mWebViewManager.getWebView(), placementName, height);
                }
            }
        });
        if (this.mWebViewManager.isSdkMonitorInstalled()) {
            this.mWebViewManager.sendRenderSuccessful(placementName);
        }
    }

    @JavascriptInterface
    public void onRenderFailure(final String placementName, final String errorMessage) {
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                OnRenderListener listener = InjectedObject.this.mWebViewManager.getOnRenderListener();
                if (listener != null) {
                    listener.onRenderFailed(InjectedObject.this.mWebViewManager.getWebView(), placementName, errorMessage);
                }
            }
        });
        if (this.mWebViewManager.isSdkMonitorInstalled()) {
            this.mWebViewManager.sendRenderFailed(placementName);
        }
    }

    @JavascriptInterface
    public void onMonitorDataRetrieved(String placementName, String data, String html) {
        if (this.mWebViewManager.isSdkMonitorInstalled()) {
            this.mWebViewManager.sendMonitorData(placementName, data, html);
        }
    }

    @JavascriptInterface
    public void handleAttributionClick(final String url) {
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                Context context = InjectedObject.this.mWebViewManager.getWebView().getContext();
                if (!PopupHelper.openPopup(context, url)) {
                    Logger.d(TAG, "failed to open popup, so opening browser");
                    OnClickHelper.openUrlInTabsOrBrowser(context, url);
                }
            }
        });
    }

    @JavascriptInterface
    public void onClick(String title, final String pageUrl, final String loggerUrl, final boolean isOrganic, final String itemId, final String placementName) {
        Logger.d(TAG, "onClick() called with: title = [" + title + "], pageUrl = [" + pageUrl + "], loggerUrl = [" + loggerUrl + "], isOrganic = [" + isOrganic + "], itemId = [" + itemId + "], placementName = [" + placementName + "]");
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                RequestUtil.performPreClickCallAsync(InjectedObject.this.mActivityContext, InjectedObject.this.mPublisherId, pageUrl, InjectedObject.this.mWebViewManager.getSdkType());
                Boolean shouldAllowNonOrganicClickOverride = InjectedObject.this.mWebViewManager.shouldAllowNonOrganicClickOverride();
                if (shouldAllowNonOrganicClickOverride == null) {
                    shouldAllowNonOrganicClickOverride = TaboolaJs.getInstance().shouldAllowNonOrganicClickOverride();
                }
                boolean shouldSdkHandleClick = true;
                TaboolaOnClickListener onClickListener = TaboolaJs.getInstance().getOnClickListener();
                if (InjectedObject.this.mWebViewManager.isSdkMonitorInstalled()) {
                    InjectedObject.this.mWebViewManager.sendPlacementClicked(placementName);
                }
                if (onClickListener != null) {
                    Logger.d(TAG, " onClickListener.onItemClick() called from main lopper from " + TAG);
                    String tag = InjectedObject.this.mWebViewManager.getTag();
                    String placement = TextUtils.isEmpty((CharSequence)tag) ? placementName : placementName + "##" + tag;
                    shouldSdkHandleClick = onClickListener.onItemClick(placement, itemId, pageUrl, isOrganic);
                } else {
                    Logger.d(TAG, "onClickListener == null");
                }
                if (shouldSdkHandleClick && !shouldAllowNonOrganicClickOverride.booleanValue()) {
                    OnClickHelper.openUrlInTabsOrBrowser(InjectedObject.this.mActivityContext, loggerUrl);
                } else if (isOrganic || shouldAllowNonOrganicClickOverride.booleanValue()) {
                    InjectedObject.this.notifyClick(loggerUrl);
                } else {
                    Logger.d(TAG, "onItemClick: Performing default click action even though click handler returned \u201cfalse\u201d.Can only override default click action for organic items");
                    OnClickHelper.openUrlInTabsOrBrowser(InjectedObject.this.mActivityContext, loggerUrl);
                }
            }
        });
    }

    @JavascriptInterface
    public void onDataRetrieved(String key, String data) {
        switch (key) {
            case "DATA_KEY_PUBLISHER_ID": {
                this.mPublisherId = data;
                break;
            }
            default: {
                Logger.e(TAG, "Unknown data key: " + key);
            }
        }
    }

    private void notifyClick(String loggerUrl) {
        this.mWebViewManager.callJsFunction("taboolaMobile.fireClickEvent(\"" + loggerUrl + "\")");
    }

    private String removeQueryParameter(String url, String paramToRemove) {
        int queryStartIndex;
        String newUrl = url;
        String paramStartString = "?" + paramToRemove + "=";
        int paramStartIndex = url.indexOf(paramStartString, queryStartIndex = url.indexOf(63));
        if (paramStartIndex == -1) {
            paramStartString = "&" + paramToRemove + "=";
            paramStartIndex = url.indexOf(paramStartString, queryStartIndex);
        }
        if (paramStartIndex == -1) {
            return newUrl;
        }
        int paramEndIndex = url.indexOf("&", paramStartIndex + 1) - 1;
        if (paramEndIndex == -1 && (paramEndIndex = url.indexOf("#", paramStartIndex)) == -1) {
            paramEndIndex = url.length() - 1;
        }
        String parameterString = url.substring(paramStartIndex, paramEndIndex + 1);
        newUrl = url.replace(parameterString, "");
        newUrl = this.removeQueryParameter(newUrl, paramToRemove);
        return newUrl;
    }
}

