/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import com.taboola.android.utils.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class MonitorManager {
    private static final String TAG = MonitorManager.class.getSimpleName();
    public static final int WEB_PLACEMENT_HTML_CHUNK_AMOUNT = 10;
    public static final int MSG_LOG = 190;
    public static final int MSG_API_PLACEMENT_RECEIVED = 121;
    public static final int MSG_API_PLACEMENT_AVAILABLE = 122;
    public static final int MSG_API_PLACEMENT_VISIBLE = 123;
    public static final int MSG_API_PLACEMENT_CLICKED = 124;
    public static final int MSG_API_PROPERTIES = 128;
    public static final int MSG_WEB_RENDER_SUCCESSFUL = 131;
    public static final int MSG_WEB_RENDER_FAILED = 132;
    public static final int MSG_WEB_PLACEMENT_CLICKED = 133;
    public static final int MSG_WEB_PLACEMENT_DATA = 138;
    public static final int MSG_WEB_PLACEMENT_HTML = 139;
    public static final int MSG_HIGHLIGHT_PLACEMENT = 291;
    public static final int MSG_WEB_EDIT_PROPERTIES = 231;
    public static final int MSG_GET_FEATURE_SET = 232;
    public static final int MSG_NETWORK_CALL_CALLS = 233;
    public static final String APPLICATION_NAME_BUNDLE_KEY = "APPLICATION_NAME_BUNDLE_KEY";
    public static final String LOG_MESSAGE_BUNDLE_KEY = "LOG_MESSAGE_BUNDLE_KEY";
    public static final String PLACEMENT_ID_BUNDLE_KEY = "PLACEMENT_ID_BUNDLE_KEY";
    public static final String PLACEMENT_NAME_BUNDLE_KEY = "PLACEMENT_NAME_BUNDLE_KEY";
    public static final String PLACEMENT_TYPE_BUNDLE_KEY = "PLACEMENT_TYPE_BUNDLE_KEY";
    public static final String PLACEMENT_PROPERTIES_BUNDLE_KEY = "PLACEMENT_PROPERTIES_BUNDLE_KEY";
    public static final String WEB_PLACEMENT_DATA_JSON_BUNDLE_KEY = "WEB_PLACEMENT_DATA_JSON_BUNDLE_KEY";
    public static final String WEB_PLACEMENT_HTML_CHUNK_BUNDLE_KEY = "WEB_PLACEMENT_HTML_CHUNK_BUNDLE_KEY";
    public static final String WEB_PLACEMENT_HTML_CHUNK_ID_BUNDLE_KEY = "WEB_PLACEMENT_HTML_CHUNK_ID_BUNDLE_KEY";
    public static final String WEB_NEW_PROPERTIES_JSON_BUNDLE_KEY = "WEB_NEW_PROPERTIES_JSON_BUNDLE_KEY";
    public static final String MONITOR_FEATURE_SET_LIST = "MONITOR_FEATURE_SET_LIST";
    public static final String SDK_DETAILS = "SDK_DETAILS";
    public static final String NETWORK_CALL_URL = "NETWORK_CALL_URL";
    public static final String NETWORK_CALL_TIMESTAMP = "NETWORK_CALL_TIMESTAMP";
    private static MonitorManager ourInstance = null;
    private Messenger mServiceMessenger = null;
    private Queue<Message> mPendingMessages = new LinkedList<Message>();
    private boolean mIsBound = false;
    private String mApplicationName;
    private ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            MonitorManager.this.mServiceMessenger = new Messenger(service);
            Logger.d(TAG, "onServiceConnected");
            MonitorManager.this.sendPendingMessages();
            MonitorManager.this.mIsBound = true;
        }

        public void onServiceDisconnected(ComponentName className) {
            Logger.d(TAG, "onServiceDisconnected");
            MonitorManager.this.mServiceMessenger = null;
            MonitorManager.this.mIsBound = false;
        }
    };

    public static MonitorManager getInstance(String applicationName) {
        if (ourInstance == null) {
            ourInstance = new MonitorManager(applicationName);
        }
        return ourInstance;
    }

    private MonitorManager(String applicationName) {
        this.mApplicationName = applicationName;
    }

    public void bindService(Context applicationContext) {
        if (!this.mIsBound) {
            Intent intent = new Intent("com.taboola.taboolasdkmonitor.ACTION_BIND");
            intent.setPackage("com.taboola.taboolasdkmonitor");
            applicationContext.getApplicationContext().bindService(intent, this.mConnection, 1);
        }
    }

    public void unbindService(Context applicationContext) {
        if (this.mIsBound) {
            applicationContext.getApplicationContext().unbindService(this.mConnection);
            this.mIsBound = false;
        }
    }

    public void sendLogMessage(String logMessage) {
        Bundle bundle = new Bundle();
        bundle.putString(LOG_MESSAGE_BUNDLE_KEY, logMessage);
        this.sendMessage(190, bundle);
    }

    public void sendGetFeatureSet(Messenger messenger, String sdkDetailsJSON) {
        Bundle bundle = new Bundle();
        bundle.putString(SDK_DETAILS, sdkDetailsJSON);
        this.sendMessage(232, bundle, messenger);
    }

    public void sendNetworkCall(long timestamp, String networkCallUrl) {
        Bundle bundle = new Bundle();
        bundle.putString(NETWORK_CALL_URL, networkCallUrl);
        bundle.putLong(NETWORK_CALL_TIMESTAMP, timestamp);
        this.sendMessage(233, bundle);
    }

    public void sendApiReceived(String placementId, String placementName, Messenger placementMessenger) {
        Bundle bundle = new Bundle();
        bundle.putString(PLACEMENT_ID_BUNDLE_KEY, placementId);
        bundle.putString(PLACEMENT_TYPE_BUNDLE_KEY, "Taboola Android SDK - API");
        bundle.putString(PLACEMENT_NAME_BUNDLE_KEY, placementName);
        this.sendMessage(121, bundle, placementMessenger);
    }

    public void sendApiAvailable(String placementId) {
        Bundle bundle = new Bundle();
        bundle.putString(PLACEMENT_ID_BUNDLE_KEY, placementId);
        this.sendMessage(122, bundle);
    }

    public void sendApiVisible(String placementId) {
        Bundle bundle = new Bundle();
        bundle.putString(PLACEMENT_ID_BUNDLE_KEY, placementId);
        this.sendMessage(123, bundle);
    }

    public void sendApiClicked(String placementId) {
        Bundle bundle = new Bundle();
        bundle.putString(PLACEMENT_ID_BUNDLE_KEY, placementId);
        this.sendMessage(124, bundle);
    }

    public void sendApiProperties(String placementId, HashMap<String, String> parameters) {
        Bundle bundle = new Bundle();
        bundle.putString(PLACEMENT_ID_BUNDLE_KEY, placementId);
        bundle.putSerializable(PLACEMENT_PROPERTIES_BUNDLE_KEY, parameters);
        this.sendMessage(128, bundle);
    }

    public void sendWebPlacementRenderSuccess(String placementId, String placementType, String placementName, Messenger webViewMessenger) {
        Bundle bundle = new Bundle();
        bundle.putString(PLACEMENT_ID_BUNDLE_KEY, placementId);
        bundle.putString(PLACEMENT_TYPE_BUNDLE_KEY, placementType);
        bundle.putString(PLACEMENT_NAME_BUNDLE_KEY, placementName);
        this.sendMessage(131, bundle, webViewMessenger);
    }

    public void sendWebPlacementRenderFailed(String placementId, String placementType, String placementName, Messenger webViewMessenger) {
        Bundle bundle = new Bundle();
        bundle.putString(PLACEMENT_ID_BUNDLE_KEY, placementId);
        bundle.putString(PLACEMENT_TYPE_BUNDLE_KEY, placementType);
        bundle.putString(PLACEMENT_NAME_BUNDLE_KEY, placementName);
        this.sendMessage(132, bundle, webViewMessenger);
    }

    public void sendWebPlacementClicked(String placementId) {
        Bundle bundle = new Bundle();
        bundle.putString(PLACEMENT_ID_BUNDLE_KEY, placementId);
        this.sendMessage(133, bundle);
    }

    public void sendWebPlacementMonitorData(String placementId, String data, String html) {
        this.sendWebPlacementData(placementId, data);
        this.sendWebPlacementHtml(placementId, html);
    }

    private void sendWebPlacementData(String placementId, String data) {
        Bundle bundle = new Bundle();
        bundle.putString(PLACEMENT_ID_BUNDLE_KEY, placementId);
        bundle.putString(WEB_PLACEMENT_DATA_JSON_BUNDLE_KEY, data);
        this.sendMessage(138, bundle);
    }

    private void sendWebPlacementHtml(String placementId, String html) {
        ArrayList<String> dataChunks = new ArrayList<String>(10);
        int chunkLength = html.length() / 10 + 1;
        int endIndex = 0;
        for (int i = 0; i < 9; ++i) {
            int beginIndex = chunkLength * i;
            endIndex = chunkLength * (i + 1);
            dataChunks.add(html.substring(beginIndex, endIndex));
        }
        dataChunks.add(html.substring(endIndex));
        this.sendWebPlacementDataInChunks(placementId, dataChunks);
    }

    private void sendWebPlacementDataInChunks(String placementId, List<String> dataChunks) {
        for (int i = 0; i < dataChunks.size(); ++i) {
            Bundle bundle = new Bundle();
            bundle.putString(PLACEMENT_ID_BUNDLE_KEY, placementId);
            bundle.putString(WEB_PLACEMENT_HTML_CHUNK_BUNDLE_KEY, dataChunks.get(i));
            bundle.putInt(WEB_PLACEMENT_HTML_CHUNK_ID_BUNDLE_KEY, i);
            this.sendMessage(139, bundle);
        }
    }

    private void sendMessage(int what, Bundle bundle) {
        this.sendMessage(what, bundle, null);
    }

    private void sendMessage(int what, Bundle bundle, Messenger replyToMessenger) {
        bundle.putString(APPLICATION_NAME_BUNDLE_KEY, this.mApplicationName);
        Message msg = Message.obtain(null, (int)what, (int)0, (int)0);
        msg.replyTo = replyToMessenger;
        msg.setData(bundle);
        if (!this.mIsBound) {
            this.mPendingMessages.add(msg);
            return;
        }
        try {
            this.mServiceMessenger.send(msg);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void sendPendingMessages() {
        while (this.mPendingMessages.size() > 0) {
            try {
                this.mServiceMessenger.send(this.mPendingMessages.poll());
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }
}

