/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils;

import android.support.annotation.IntRange;
import android.util.Log;
import com.taboola.android.MonitorManager;

public class Logger {
    public static final int ERROR = 6;
    public static final int WARN = 5;
    public static final int INFO = 4;
    public static final int DEBUG = 3;
    public static final int VERBOSE = 2;
    private static int mCurrentLogLevel = 6;
    private static MonitorManager mSdkMonitorManager = null;

    public static void setLogLevel(@IntRange(from=2L, to=6L) int logLevel) {
        mCurrentLogLevel = logLevel;
    }

    public static int getLogLevel() {
        return mCurrentLogLevel;
    }

    public static void setSdkMonitorManager(MonitorManager connector) {
        mSdkMonitorManager = connector;
    }

    public static void e(String tag, String message) {
        if (mCurrentLogLevel <= 6) {
            Log.e((String)tag, (String)message);
        }
        if (mSdkMonitorManager != null) {
            Logger.monitorLog("E", tag, message);
        }
    }

    public static void e(String tag, String message, Exception e) {
        if (mCurrentLogLevel <= 6) {
            Log.e((String)tag, (String)message, (Throwable)e);
        }
        if (mSdkMonitorManager != null) {
            Logger.monitorLog("E", tag, message + " " + e.toString());
        }
    }

    public static void w(String tag, String message) {
        if (mCurrentLogLevel <= 5) {
            Log.w((String)tag, (String)message);
        }
        if (mSdkMonitorManager != null) {
            Logger.monitorLog("W", tag, message);
        }
    }

    public static void i(String tag, String message) {
        if (mCurrentLogLevel <= 4) {
            Log.i((String)tag, (String)message);
        }
        if (mSdkMonitorManager != null) {
            Logger.monitorLog("I", tag, message);
        }
    }

    public static void d(String tag, String message) {
        if (mCurrentLogLevel <= 3) {
            Log.d((String)tag, (String)message);
        }
        if (mSdkMonitorManager != null) {
            Logger.monitorLog("D", tag, message);
        }
    }

    public static void v(String tag, String message) {
        if (mCurrentLogLevel <= 2) {
            Log.v((String)tag, (String)message);
        }
        if (mSdkMonitorManager != null) {
            Logger.monitorLog("V", tag, message);
        }
    }

    private static void monitorLog(String level, String tag, String message) {
        mSdkMonitorManager.sendLogMessage(System.currentTimeMillis() + " " + level + "/" + tag + ": " + message + "\n");
    }
}

