package com.taboola.android.api;

public interface TaboolaOnClickListener {
    /**
     * Sdk allows to intercept recommendation clicks, and block default click handling for organic items.
     * If you wand to block the default behavior, and display the recommendation content on your own,
     * return {@code false} in {@link TaboolaOnClickListener#onItemClick(String, String, String, boolean)}
     * <p> Note: The return value will be ignored for non-organic items (!).
     * <p>The method will be called every time a user clicks a recommendation, right before triggering the default behavior
     *
     * @param placementName
     * @param itemId
     * @param clickUrl
     * @param isOrganic
     * @return
     */
    boolean onItemClick(String placementName, String itemId, String clickUrl, boolean isOrganic);
}