/*
 * Decompiled with CFR 0.152.
 */
package com.sys1yagi.loco.store.android.sqlite.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.text.TextUtils;
import android.util.Log;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.framework.FrameworkSQLiteOpenHelperFactory;
import com.sys1yagi.loco.core.internal.SmashedLog;
import com.sys1yagi.loco.store.android.sqlite.database.Record;
import com.sys1yagi.loco.store.android.sqlite.internal.ProcessName;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014J\b\u0010\u0015\u001a\u00020\u000fH\u0004J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018J\u0012\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\"\u0010\u001c\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010!\u001a\u00020\u0011R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006#"}, d2={"Lcom/sys1yagi/loco/store/android/sqlite/database/LocoAndroidSqliteDatabase;", "Landroidx/sqlite/db/SupportSQLiteOpenHelper$Callback;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "openHelper", "Landroidx/sqlite/db/SupportSQLiteOpenHelper;", "kotlin.jvm.PlatformType", "getOpenHelper", "()Landroidx/sqlite/db/SupportSQLiteOpenHelper;", "buildRecord", "Lcom/sys1yagi/loco/store/android/sqlite/database/Record;", "cursor", "Landroid/database/Cursor;", "clear", "", "count", "", "delete", "records", "", "finalize", "insert", "log", "Lcom/sys1yagi/loco/core/internal/SmashedLog;", "onCreate", "db", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "onUpgrade", "oldVersion", "newVersion", "recordsFromCursor", "select", "size", "Companion", "loco-store-android-sqlite_release"})
public final class LocoAndroidSqliteDatabase
extends SupportSQLiteOpenHelper.Callback {
    private final SupportSQLiteOpenHelper openHelper;
    private static final String DATABASE_NAME = "loco-android-sqlite.db";
    private static final String TABLE_NAME = "logs";
    private static final String COLUMN_NAME_LOG_TYPE = "log_type";
    private static final String COLUMN_NAME_SMASHER_TYPE = "smasher_type";
    private static final String COLUMN_NAME_SENDER_TYPE = "sender_type";
    private static final String COLUMN_NAME_SMASHED_LOG = "smashed_log";
    private static final String COLUMN_NAME_CREATED_AT = "created_at";
    private static final int DATABASE_VERSION = 1;
    public static final Companion Companion = new Companion(null);

    public final SupportSQLiteOpenHelper getOpenHelper() {
        return this.openHelper;
    }

    public void onCreate(@Nullable SupportSQLiteDatabase db) {
        block0: {
            String query = StringsKt.trimIndent((String)("\n            CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " (\n                id INTEGER PRIMARY KEY,\n                " + COLUMN_NAME_LOG_TYPE + " TEXT,\n                " + COLUMN_NAME_SMASHER_TYPE + " TEXT,\n                " + COLUMN_NAME_SENDER_TYPE + " TEXT,\n                " + COLUMN_NAME_SMASHED_LOG + " TEXT,\n                " + COLUMN_NAME_CREATED_AT + " INTEGER\n            );\n        "));
            SupportSQLiteDatabase supportSQLiteDatabase = db;
            if (supportSQLiteDatabase == null) break block0;
            supportSQLiteDatabase.execSQL(query);
        }
    }

    public void onUpgrade(@Nullable SupportSQLiteDatabase db, int oldVersion, int newVersion) {
        Log.e((String)"LocoAndroidSqlite", (String)("unexpected onUpgrade(db, " + oldVersion + ", " + newVersion + ')'));
    }

    public final void insert(@NotNull SmashedLog log) {
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(log.getUniqueId()));
        contentValues.put(COLUMN_NAME_LOG_TYPE, log.getLogTypeName());
        contentValues.put(COLUMN_NAME_SMASHER_TYPE, log.getSmasherTypeName());
        contentValues.put(COLUMN_NAME_SENDER_TYPE, log.getSenderTypeName());
        contentValues.put(COLUMN_NAME_SMASHED_LOG, log.getSmashedLog());
        contentValues.put(COLUMN_NAME_CREATED_AT, Long.valueOf(System.currentTimeMillis()));
        SupportSQLiteOpenHelper supportSQLiteOpenHelper = this.openHelper;
        Intrinsics.checkExpressionValueIsNotNull((Object)supportSQLiteOpenHelper, (String)"openHelper");
        supportSQLiteOpenHelper.getWritableDatabase().insert(TABLE_NAME, 2, contentValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Record> select(int size) {
        String query = StringsKt.trimIndent((String)("\n            SELECT * FROM " + TABLE_NAME + "\n                ORDER BY " + COLUMN_NAME_CREATED_AT + " ASC\n                LIMIT " + size + "\n        "));
        SupportSQLiteOpenHelper supportSQLiteOpenHelper = this.openHelper;
        Intrinsics.checkExpressionValueIsNotNull((Object)supportSQLiteOpenHelper, (String)"openHelper");
        Closeable closeable = (Closeable)supportSQLiteOpenHelper.getReadableDatabase().query(query, new Object[0]);
        boolean bl = false;
        Throwable throwable = null;
        try {
            Cursor cursor = (Cursor)closeable;
            boolean bl2 = false;
            Cursor cursor2 = cursor;
            Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
            List<Record> list = this.recordsFromCursor(cursor2);
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void delete(@NotNull List<Record> records) {
        Collection<Long> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(records, (String)"records");
        Iterable iterable = records;
        StringBuilder stringBuilder = new StringBuilder().append("\n            DELETE FROM ").append(TABLE_NAME).append("\n            WHERE id IN (");
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Record record = (Record)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Long l = it.getId();
            collection.add(l);
        }
        collection = (List)destination$iv$iv;
        String query = StringsKt.trimIndent((String)stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).append(" )\n        ").toString());
        SupportSQLiteOpenHelper supportSQLiteOpenHelper = this.openHelper;
        Intrinsics.checkExpressionValueIsNotNull((Object)supportSQLiteOpenHelper, (String)"openHelper");
        supportSQLiteOpenHelper.getWritableDatabase().execSQL(query);
    }

    public final void clear() {
        String query = StringsKt.trimIndent((String)("\n            DELETE FROM " + TABLE_NAME + "\n        "));
        SupportSQLiteOpenHelper supportSQLiteOpenHelper = this.openHelper;
        Intrinsics.checkExpressionValueIsNotNull((Object)supportSQLiteOpenHelper, (String)"openHelper");
        supportSQLiteOpenHelper.getWritableDatabase().execSQL(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int count() {
        String query = "SELECT COUNT(*) FROM " + TABLE_NAME;
        SupportSQLiteOpenHelper supportSQLiteOpenHelper = this.openHelper;
        Intrinsics.checkExpressionValueIsNotNull((Object)supportSQLiteOpenHelper, (String)"openHelper");
        Closeable closeable = (Closeable)supportSQLiteOpenHelper.getReadableDatabase().query(query, null);
        boolean bl = false;
        Throwable throwable = null;
        try {
            Cursor cursor = (Cursor)closeable;
            boolean bl2 = false;
            int n = cursor.moveToNext() ? cursor.getInt(0) : 0;
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final List<Record> recordsFromCursor(Cursor cursor) {
        boolean bl = false;
        List records = new ArrayList();
        while (cursor.moveToNext()) {
            Record record = this.buildRecord(cursor);
            records.add(record);
        }
        return records;
    }

    private final Record buildRecord(Cursor cursor) {
        long l = cursor.getLong(0);
        String string = cursor.getString(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cursor.getString(1)");
        String string2 = cursor.getString(2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"cursor.getString(2)");
        String string3 = cursor.getString(3);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"cursor.getString(3)");
        String string4 = cursor.getString(4);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"cursor.getString(4)");
        return new Record(l, string, string2, string3, string4);
    }

    protected final void finalize() {
        this.openHelper.close();
    }

    public LocoAndroidSqliteDatabase(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(DATABASE_VERSION);
        this.openHelper = new FrameworkSQLiteOpenHelperFactory().create(SupportSQLiteOpenHelper.Configuration.builder((Context)context).name(Companion.databaseName(context)).callback((SupportSQLiteOpenHelper.Callback)this).build());
    }

    static {
        DATABASE_NAME = DATABASE_NAME;
        TABLE_NAME = TABLE_NAME;
        COLUMN_NAME_LOG_TYPE = COLUMN_NAME_LOG_TYPE;
        COLUMN_NAME_SMASHER_TYPE = COLUMN_NAME_SMASHER_TYPE;
        COLUMN_NAME_SENDER_TYPE = COLUMN_NAME_SENDER_TYPE;
        COLUMN_NAME_SMASHED_LOG = COLUMN_NAME_SMASHED_LOG;
        COLUMN_NAME_CREATED_AT = COLUMN_NAME_CREATED_AT;
        DATABASE_VERSION = 1;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/sys1yagi/loco/store/android/sqlite/database/LocoAndroidSqliteDatabase$Companion;", "", "()V", "COLUMN_NAME_CREATED_AT", "", "COLUMN_NAME_LOG_TYPE", "COLUMN_NAME_SENDER_TYPE", "COLUMN_NAME_SMASHED_LOG", "COLUMN_NAME_SMASHER_TYPE", "DATABASE_NAME", "DATABASE_VERSION", "", "TABLE_NAME", "databaseName", "context", "Landroid/content/Context;", "loco-store-android-sqlite_release"})
    public static final class Companion {
        @NotNull
        public final String databaseName(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            String processName = ProcessName.INSTANCE.getAndroidProcessName(context);
            return TextUtils.isEmpty((CharSequence)processName) ? DATABASE_NAME : processName + '.' + DATABASE_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

