/*
 * Decompiled with CFR 0.152.
 */
package com.synnapps.carouselview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.synnapps.carouselview.CirclePageIndicator;
import com.synnapps.carouselview.ImageListener;
import com.synnapps.carouselview.R;
import com.synnapps.carouselview.ViewListener;
import java.util.Timer;
import java.util.TimerTask;

public class CarouselView
extends FrameLayout {
    private final int DEFAULT_SLIDE_INTERVAL = 3500;
    private int mPageCount;
    private int slideInterval = 3500;
    private int mIndicatorGravity;
    private int indicatorMarginVertical;
    private int indicatorMarginHorizontal;
    private ViewPager containerViewPager;
    private CirclePageIndicator mIndicator;
    private ViewListener mViewListener = null;
    private ImageListener mImageListener = null;
    private Timer swipeTimer;
    private SwipeTask swipeTask;
    private boolean autoPlay;
    private boolean disableAutoPlayOnUserInteraction;
    private int previousState;
    ViewPager.OnPageChangeListener carouselOnPageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
        }

        public void onPageScrollStateChanged(int state) {
            if (CarouselView.this.previousState == 1 && state == 2) {
                if (CarouselView.this.disableAutoPlayOnUserInteraction) {
                    CarouselView.this.pauseCarousel();
                } else {
                    CarouselView.this.playCarousel();
                }
            } else if (CarouselView.this.previousState != 2 || state == 0) {
                // empty if block
            }
            CarouselView.this.previousState = state;
        }
    };

    public CarouselView(Context context) {
        super(context);
    }

    public CarouselView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs, 0, 0);
    }

    public CarouselView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public CarouselView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context, attrs, defStyleAttr, defStyleRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (this.isInEditMode()) {
            return;
        }
        View view = LayoutInflater.from((Context)context).inflate(R.layout.view_carousel, (ViewGroup)this, true);
        this.containerViewPager = (ViewPager)view.findViewById(R.id.containerViewPager);
        this.mIndicator = (CirclePageIndicator)view.findViewById(R.id.indicator);
        this.containerViewPager.addOnPageChangeListener(this.carouselOnPageChangeListener);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CarouselView, defStyleAttr, 0);
        try {
            float strokeWidth;
            float radius;
            int pageColor;
            this.setIndicatorMarginVertical(a.getInt(R.styleable.CarouselView_indicatorMarginVertical, this.getResources().getDimensionPixelSize(R.dimen.default_indicator_margin_vertical)));
            this.setIndicatorMarginHorizontal(a.getInt(R.styleable.CarouselView_indicatorMarginHorizontal, this.getResources().getDimensionPixelSize(R.dimen.default_indicator_margin_horizontal)));
            this.setSlideInterval(a.getInt(R.styleable.CarouselView_slideInterval, 3500));
            this.setOrientation(a.getInt(R.styleable.CarouselView_indicatorOrientation, 0));
            this.setIndicatorGravity(a.getInt(R.styleable.CarouselView_indicatorGravity, 81));
            this.setAutoPlay(a.getBoolean(R.styleable.CarouselView_autoPlay, true));
            this.setDisableAutoPlayOnUserInteraction(a.getBoolean(R.styleable.CarouselView_disableAutoPlayOnUserInteraction, false));
            int fillColor = a.getColor(R.styleable.CarouselView_fillColor, 0);
            if (fillColor != 0) {
                this.setFillColor(fillColor);
            }
            if ((pageColor = a.getColor(R.styleable.CarouselView_pageColor, 0)) != 0) {
                this.setPageColor(pageColor);
            }
            if ((radius = (float)a.getDimensionPixelSize(R.styleable.CarouselView_radius, 0)) != 0.0f) {
                this.setRadius(radius);
            }
            this.setSnap(a.getBoolean(R.styleable.CarouselView_snap, this.getResources().getBoolean(R.bool.default_circle_indicator_snap)));
            int strokeColor = a.getColor(R.styleable.CarouselView_strokeColor, 0);
            if (strokeColor != 0) {
                this.setStrokeColor(strokeColor);
            }
            if ((strokeWidth = (float)a.getDimensionPixelSize(R.styleable.CarouselView_strokeWidth, 0)) != 0.0f) {
                this.setStrokeWidth(strokeWidth);
            }
        }
        finally {
            a.recycle();
        }
    }

    public int getSlideInterval() {
        return this.slideInterval;
    }

    public void setSlideInterval(int slideInterval) {
        this.slideInterval = slideInterval;
    }

    public void reSetSlideInterval(int slideInterval) {
        this.slideInterval = slideInterval;
        if (null != this.containerViewPager) {
            this.playCarousel();
        }
    }

    public boolean isAutoPlay() {
        return this.autoPlay;
    }

    private void setAutoPlay(boolean autoPlay) {
        this.autoPlay = autoPlay;
    }

    public boolean isDisableAutoPlayOnUserInteraction() {
        return this.disableAutoPlayOnUserInteraction;
    }

    private void setDisableAutoPlayOnUserInteraction(boolean disableAutoPlayOnUserInteraction) {
        this.disableAutoPlayOnUserInteraction = disableAutoPlayOnUserInteraction;
    }

    private void setData() {
        CarouselPagerAdapter carouselPagerAdapter = new CarouselPagerAdapter(this.getContext());
        this.containerViewPager.setAdapter((PagerAdapter)carouselPagerAdapter);
        this.mIndicator.setViewPager(this.containerViewPager);
        this.containerViewPager.setOffscreenPageLimit(this.getPageCount());
        this.playCarousel();
    }

    private void stopScrollTimer() {
        if (null != this.swipeTimer) {
            this.swipeTimer.cancel();
        }
        if (null != this.swipeTask) {
            this.swipeTask.cancel();
        }
    }

    private void resetScrollTimer() {
        this.stopScrollTimer();
        this.swipeTask = new SwipeTask();
        this.swipeTimer = new Timer();
    }

    public void playCarousel() {
        this.resetScrollTimer();
        if (this.autoPlay && this.slideInterval > 0 && this.containerViewPager.getAdapter() != null && this.containerViewPager.getAdapter().getCount() > 1) {
            this.swipeTimer.schedule((TimerTask)this.swipeTask, this.slideInterval, (long)this.slideInterval);
        }
    }

    public void pauseCarousel() {
        this.resetScrollTimer();
    }

    public void stopCarousel() {
        this.autoPlay = false;
    }

    public void setImageListener(ImageListener mImageListener) {
        this.mImageListener = mImageListener;
    }

    public void setViewListener(ViewListener mViewListener) {
        this.mViewListener = mViewListener;
    }

    public int getPageCount() {
        return this.mPageCount;
    }

    public void setPageCount(int mPageCount) {
        this.mPageCount = mPageCount;
        this.setData();
    }

    public void addOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.containerViewPager.addOnPageChangeListener(listener);
    }

    public void setCurrentItem(int item) {
        this.containerViewPager.setCurrentItem(item);
    }

    public int getIndicatorMarginVertical() {
        return this.indicatorMarginVertical;
    }

    public void setIndicatorMarginVertical(int _indicatorMarginVertical) {
        this.indicatorMarginVertical = _indicatorMarginVertical;
    }

    public int getIndicatorMarginHorizontal() {
        return this.indicatorMarginHorizontal;
    }

    public void setIndicatorMarginHorizontal(int _indicatorMarginHorizontal) {
        this.indicatorMarginHorizontal = _indicatorMarginHorizontal;
    }

    public int getIndicatorGravity() {
        return this.mIndicatorGravity;
    }

    public void setIndicatorGravity(int gravity) {
        this.mIndicatorGravity = gravity;
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = this.mIndicatorGravity;
        params.setMargins(this.indicatorMarginHorizontal, this.indicatorMarginVertical, this.indicatorMarginHorizontal, this.indicatorMarginVertical);
        this.mIndicator.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public int getOrientation() {
        return this.mIndicator.getOrientation();
    }

    public int getFillColor() {
        return this.mIndicator.getFillColor();
    }

    public int getStrokeColor() {
        return this.mIndicator.getStrokeColor();
    }

    public void setSnap(boolean snap) {
        this.mIndicator.setSnap(snap);
    }

    public void setRadius(float radius) {
        this.mIndicator.setRadius(radius);
    }

    public float getStrokeWidth() {
        return this.mIndicator.getStrokeWidth();
    }

    public void setBackground(Drawable background) {
        super.setBackground(background);
    }

    public Drawable getIndicatorBackground() {
        return this.mIndicator.getBackground();
    }

    public void setFillColor(int fillColor) {
        this.mIndicator.setFillColor(fillColor);
    }

    public int getPageColor() {
        return this.mIndicator.getPageColor();
    }

    public void setOrientation(int orientation) {
        this.mIndicator.setOrientation(orientation);
    }

    public boolean isSnap() {
        return this.mIndicator.isSnap();
    }

    public void setStrokeColor(int strokeColor) {
        this.mIndicator.setStrokeColor(strokeColor);
    }

    public float getRadius() {
        return this.mIndicator.getRadius();
    }

    public void setPageColor(int pageColor) {
        this.mIndicator.setPageColor(pageColor);
    }

    public void setStrokeWidth(float strokeWidth) {
        this.mIndicator.setStrokeWidth(strokeWidth);
    }

    private class SwipeTask
    extends TimerTask {
        private SwipeTask() {
        }

        @Override
        public void run() {
            CarouselView.this.containerViewPager.post(new Runnable(){

                @Override
                public void run() {
                    CarouselView.this.containerViewPager.setCurrentItem((CarouselView.this.containerViewPager.getCurrentItem() + 1) % CarouselView.this.getPageCount(), true);
                }
            });
        }
    }

    private class CarouselPagerAdapter
    extends PagerAdapter {
        private Context mContext;

        public CarouselPagerAdapter(Context context) {
            this.mContext = context;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object instantiateItem(ViewGroup collection, int position) {
            View objectToReturn;
            if (CarouselView.this.mImageListener != null) {
                ImageView imageView = new ImageView(this.mContext);
                imageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
                imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                objectToReturn = imageView;
                CarouselView.this.mImageListener.setImageForPosition(position, imageView);
                collection.addView((View)imageView);
                return objectToReturn;
            } else {
                if (CarouselView.this.mViewListener == null) throw new RuntimeException("View must set " + ImageListener.class.getSimpleName() + " or " + ViewListener.class.getSimpleName() + ".");
                View view = CarouselView.this.mViewListener.setViewForPosition(position);
                if (null == view) throw new RuntimeException("View can not be null for position " + position);
                objectToReturn = view;
                collection.addView(view);
            }
            return objectToReturn;
        }

        public void destroyItem(ViewGroup collection, int position, Object view) {
            collection.removeView((View)view);
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        public int getCount() {
            return CarouselView.this.getPageCount();
        }
    }
}

