/*
 * Decompiled with CFR 0.152.
 */
package com.synnapps.carouselview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.synnapps.carouselview.CirclePageIndicator;
import com.synnapps.carouselview.ImageListener;
import com.synnapps.carouselview.PageIndicator;
import com.synnapps.carouselview.R;
import java.util.Timer;
import java.util.TimerTask;

public class CarouselView
extends FrameLayout {
    private final int DEFAULT_SLIDE_INTERVAL = 3500;
    private int mPageCount;
    private int slideInterval = 3500;
    private ViewPager containerViewPager;
    private PageIndicator mIndicator;
    private ImageListener mImageListener;

    public CarouselView(Context context) {
        super(context);
    }

    public CarouselView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs, 0, 0);
    }

    public CarouselView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public CarouselView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context, attrs, defStyleAttr, defStyleRes);
    }

    private void initView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (this.isInEditMode()) {
            return;
        }
        View view = LayoutInflater.from((Context)context).inflate(R.layout.view_carousel, (ViewGroup)this, true);
        this.containerViewPager = (ViewPager)view.findViewById(R.id.containerViewPager);
        this.mIndicator = (CirclePageIndicator)this.findViewById(R.id.indicator);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CarouselView, defStyleAttr, 0);
        this.slideInterval = a.getInt(R.styleable.CirclePageIndicator_android_orientation, 3500);
    }

    public void setData() {
        CarouselPagerAdapter carouselPagerAdapter = new CarouselPagerAdapter(this.getContext());
        this.containerViewPager.setAdapter((PagerAdapter)carouselPagerAdapter);
        this.mIndicator.setViewPager(this.containerViewPager);
        Timer swipeTimer = new Timer();
        swipeTimer.schedule((TimerTask)new SwipeTask(), this.slideInterval, (long)this.slideInterval);
    }

    public void setImageListener(ImageListener mImageListener) {
        this.mImageListener = mImageListener;
    }

    public int getPageCount() {
        return this.mPageCount;
    }

    public void setPageCount(int mPageCount) {
        this.mPageCount = mPageCount;
        this.setData();
    }

    private class SwipeTask
    extends TimerTask {
        private SwipeTask() {
        }

        @Override
        public void run() {
            CarouselView.this.containerViewPager.post(new Runnable(){

                @Override
                public void run() {
                    CarouselView.this.containerViewPager.setCurrentItem((CarouselView.this.containerViewPager.getCurrentItem() + 1) % CarouselView.this.getPageCount(), true);
                }
            });
        }
    }

    private class CarouselPagerAdapter
    extends PagerAdapter {
        private Context mContext;

        public CarouselPagerAdapter(Context context) {
            this.mContext = context;
        }

        public Object instantiateItem(ViewGroup collection, int position) {
            ImageView imageView = new ImageView(this.mContext);
            imageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
            CarouselView.this.mImageListener.setImageForPosition(position, imageView);
            collection.addView((View)imageView);
            return imageView;
        }

        public void destroyItem(ViewGroup collection, int position, Object view) {
            collection.removeView((View)view);
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        public int getCount() {
            return CarouselView.this.getPageCount();
        }
    }
}

