/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.english;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import de.l3s.boilerpipe.filters.english.HeuristicFilterBase;

public final class IgnoreBlocksAfterContentFilter
extends HeuristicFilterBase
implements BoilerpipeFilter {
    public static final IgnoreBlocksAfterContentFilter DEFAULT_INSTANCE = new IgnoreBlocksAfterContentFilter(60);
    public static final IgnoreBlocksAfterContentFilter INSTANCE_200 = new IgnoreBlocksAfterContentFilter(200);
    private final int minNumWords;

    public static IgnoreBlocksAfterContentFilter getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public IgnoreBlocksAfterContentFilter(int minNumWords) {
        this.minNumWords = minNumWords;
    }

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        boolean changes = false;
        int numWords = 0;
        boolean foundEndOfText = false;
        for (TextBlock block : doc.getTextBlocks()) {
            boolean endOfText = block.hasLabel("de.l3s.boilerpipe/INDICATES_END_OF_TEXT");
            if (block.isContent()) {
                numWords += IgnoreBlocksAfterContentFilter.getNumFullTextWords(block);
            }
            if (endOfText && numWords >= this.minNumWords) {
                foundEndOfText = true;
            }
            if (!foundEndOfText) continue;
            changes = true;
            block.setIsContent(false);
        }
        return changes;
    }
}

