/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.support;

import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogLevel;
import com.simba.athena.support.exceptions.ErrorException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;

public class LogUtilities {
    public static void logDebug(ErrorException errorException, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.DEBUG, iLogger)) {
            return;
        }
        String[] stringArray = LogUtilities.getNames("logDebug");
        iLogger.logDebug(stringArray[0], stringArray[1], stringArray[2], errorException);
    }

    public static void logDebug(Exception exception, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.DEBUG, iLogger)) {
            return;
        }
        String[] stringArray = LogUtilities.getNames("logDebug");
        iLogger.logDebug(stringArray[0], stringArray[1], stringArray[2], LogUtilities.getExceptionMessage(exception));
    }

    public static void logDebug(String string, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.DEBUG, iLogger)) {
            return;
        }
        String[] stringArray = LogUtilities.getNames("logDebug");
        iLogger.logDebug(stringArray[0], stringArray[1], stringArray[2], string);
    }

    public static void logError(ErrorException errorException, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.ERROR, iLogger)) {
            return;
        }
        String[] stringArray = LogUtilities.getNames("logError");
        iLogger.logError(stringArray[0], stringArray[1], stringArray[2], errorException);
    }

    public static void logError(Exception exception, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.ERROR, iLogger)) {
            return;
        }
        String[] stringArray = LogUtilities.getNames("logError");
        iLogger.logError(stringArray[0], stringArray[1], stringArray[2], LogUtilities.getExceptionMessage(exception));
    }

    public static void logError(String string, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.ERROR, iLogger)) {
            return;
        }
        String[] stringArray = LogUtilities.getNames("logError");
        iLogger.logError(stringArray[0], stringArray[1], stringArray[2], string);
    }

    public static void logFatal(Exception exception, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.FATAL, iLogger)) {
            return;
        }
        String[] stringArray = LogUtilities.getNames("logFatal");
        iLogger.logFatal(stringArray[0], stringArray[1], stringArray[2], LogUtilities.getExceptionMessage(exception));
    }

    public static void logFatal(String string, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.FATAL, iLogger)) {
            return;
        }
        String[] stringArray = LogUtilities.getNames("logFatal");
        iLogger.logFatal(stringArray[0], stringArray[1], stringArray[2], string);
    }

    public static void logFunctionEntrance(ILogger iLogger, Object ... objectArray) {
        if (!LogUtilities.shouldLogLevel(LogLevel.TRACE, iLogger)) {
            return;
        }
        String[] stringArray = LogUtilities.getNames("logFunctionEntrance");
        iLogger.logFunctionEntrance(stringArray[0], stringArray[1], stringArray[2] + LogUtilities.formatArguments(objectArray));
    }

    public static void logInfo(Exception exception, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.INFO, iLogger)) {
            return;
        }
        String[] stringArray = LogUtilities.getNames("logInfo");
        iLogger.logInfo(stringArray[0], stringArray[1], stringArray[2], LogUtilities.getExceptionMessage(exception));
    }

    public static void logInfo(String string, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.INFO, iLogger)) {
            return;
        }
        String[] stringArray = LogUtilities.getNames("logInfo");
        iLogger.logInfo(stringArray[0], stringArray[1], stringArray[2], string);
    }

    public static void logTrace(Exception exception, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.TRACE, iLogger)) {
            return;
        }
        String[] stringArray = LogUtilities.getNames("logTrace");
        iLogger.logTrace(stringArray[0], stringArray[1], stringArray[2], LogUtilities.getExceptionMessage(exception));
    }

    public static void logTrace(String string, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.TRACE, iLogger)) {
            return;
        }
        String[] stringArray = LogUtilities.getNames("logTrace");
        iLogger.logTrace(stringArray[0], stringArray[1], stringArray[2], string);
    }

    public static void logWarning(Exception exception, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.WARNING, iLogger)) {
            return;
        }
        String[] stringArray = LogUtilities.getNames("logWarning");
        iLogger.logWarning(stringArray[0], stringArray[1], stringArray[2], LogUtilities.getExceptionMessage(exception));
    }

    public static void logWarning(String string, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.WARNING, iLogger)) {
            return;
        }
        String[] stringArray = LogUtilities.getNames("logWarning");
        iLogger.logWarning(stringArray[0], stringArray[1], stringArray[2], string);
    }

    public static boolean shouldLogLevel(LogLevel logLevel, ILogger iLogger) {
        return iLogger.isEnabled() && logLevel.ordinal() <= iLogger.getLogLevel().ordinal();
    }

    private static String formatArguments(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder("(");
        if (null == objectArray) {
            stringBuilder.append("null");
        } else {
            boolean bl = true;
            for (Object object : objectArray) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                bl = false;
                if (null == object) {
                    stringBuilder.append("null");
                    continue;
                }
                if (object instanceof String) {
                    stringBuilder.append("\"").append(object.toString()).append("\"");
                    continue;
                }
                if (object instanceof Iterable) {
                    stringBuilder.append("<");
                    bl = true;
                    Iterator iterator = ((Iterable)object).iterator();
                    while (iterator.hasNext()) {
                        if (!bl) {
                            stringBuilder.append(", ");
                        }
                        bl = false;
                        Object t = iterator.next();
                        if (null == t) {
                            stringBuilder.append("null");
                            continue;
                        }
                        stringBuilder.append(t.toString());
                    }
                    bl = false;
                    stringBuilder.append(">");
                    continue;
                }
                stringBuilder.append(object.toString());
            }
        }
        return stringBuilder.append(")").toString();
    }

    private static String getExceptionMessage(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return exception.getLocalizedMessage() + "\n" + stringWriter.toString();
    }

    private static String[] getNames(String string) {
        StackTraceElement stackTraceElement = LogUtilities.getStackElementAbove(string);
        String[] stringArray = new String[3];
        stringArray[2] = stackTraceElement.getMethodName();
        try {
            Class<?> clazz = Class.forName(stackTraceElement.getClassName());
            stringArray[1] = clazz.getSimpleName();
            stringArray[0] = "";
            Package package_ = clazz.getPackage();
            if (null != package_) {
                stringArray[0] = package_.getName();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            stringArray[0] = "<error>";
            stringArray[1] = stackTraceElement.getClassName();
        }
        if (stringArray[2].equals("<init>")) {
            stringArray[2] = stringArray[1];
        }
        return stringArray;
    }

    private static StackTraceElement getStackElementAbove(String string) {
        boolean bl = false;
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            if (bl) {
                return stackTraceElement;
            }
            if (!stackTraceElement.getMethodName().equals(string)) continue;
            bl = true;
        }
        return Thread.currentThread().getStackTrace()[3];
    }
}

