/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.streams.parameters;

import com.simba.athena.dsi.dataengine.utilities.DataWrapper;
import com.simba.athena.dsi.dataengine.utilities.ParameterInputValue;
import com.simba.athena.dsi.dataengine.utilities.ParameterMetadata;
import com.simba.athena.dsi.exceptions.InputOutputException;
import com.simba.athena.exceptions.JDBCMessageKey;
import com.simba.athena.streams.parameters.AbstractParameterStream;
import java.io.IOException;
import java.io.InputStream;

public class AsciiParameterStream
extends AbstractParameterStream {
    public AsciiParameterStream(InputStream inputStream, long l) {
        super(inputStream, l);
    }

    @Deprecated
    public AsciiParameterStream(InputStream inputStream, long l, ParameterMetadata parameterMetadata, int n) {
        super(inputStream, l, parameterMetadata, n);
    }

    @Override
    public ParameterInputValue getNextValue() throws IOException {
        if (this.isClosed()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CLOSED.name());
        }
        if (!this.hasMoreData()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_EMPTY.name());
        }
        if (null == this.m_parameterMetadata) {
            throw new InputOutputException(1, JDBCMessageKey.NULL_PARAM_METADATA.name());
        }
        if (!this.m_valuesPushed) {
            this.m_valuesPushed = true;
        }
        int n = this.getNumToFetch();
        byte[] byArray = new byte[n];
        int n2 = 0;
        try {
            n2 = this.m_stream.read(byArray, 0, n);
        }
        catch (IOException iOException) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_UNEXPECTED_END.name());
        }
        this.m_numRead += (long)n2;
        DataWrapper dataWrapper = new DataWrapper();
        if (-1L != this.m_streamLength) {
            if (-1 == n2) {
                throw new InputOutputException(1, JDBCMessageKey.STREAM_UNEXPECTED_END.name());
            }
        } else {
            this.m_lastChunkReadSize = n2;
            if (n2 < byArray.length && -1 != n2) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                byArray = byArray2;
                this.m_lastChunkReadSize = -1L;
            } else if (-1 == n2) {
                byArray = new byte[]{};
            }
        }
        if (12 == this.m_parameterMetadata.getTypeMetadata().getType()) {
            dataWrapper.setVarChar(new String(byArray));
        } else {
            dataWrapper.setLongVarChar(new String(byArray));
        }
        return new ParameterInputValue(this.m_parameterMetadata, dataWrapper);
    }
}

