/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.jdbc.jdbc41;

import com.simba.athena.exceptions.ExceptionConverter;
import com.simba.athena.exceptions.JDBCMessageKey;
import com.simba.athena.jdbc.common.SConnection;
import com.simba.athena.jdbc.common.SConnectionHandle;
import com.simba.athena.jdbc.common.SPooledConnection;
import com.simba.athena.jdbc.jdbc41.S41Connection;
import com.simba.athena.jdbc.jdbc41.S41PooledConnection;
import com.simba.athena.jdbc.jdbc41.S41PreparedStatement;
import com.simba.athena.jdbc.jdbc41.S41PreparedStatementHandle;
import com.simba.athena.support.exceptions.ExceptionType;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.Executor;

public class S41ConnectionHandle
extends SConnectionHandle {
    public S41ConnectionHandle(SConnection sConnection, SPooledConnection sPooledConnection) throws SQLException {
        super(sConnection, sPooledConnection);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkIfOpen();
        try {
            return ((S41Connection)this.m_connection).getClientInfo();
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        this.checkIfOpen();
        try {
            return ((S41Connection)this.m_connection).getClientInfo(string);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement preparedStatement = this.m_connection.prepareStatement(string);
            return new S41PreparedStatementHandle((S41PooledConnection)this.m_pooledConnection, (S41PreparedStatement)preparedStatement);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement preparedStatement = this.m_connection.prepareStatement(string, n);
            return new S41PreparedStatementHandle((S41PooledConnection)this.m_pooledConnection, (S41PreparedStatement)preparedStatement);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement preparedStatement = this.m_connection.prepareStatement(string, n, n2);
            return new S41PreparedStatementHandle((S41PooledConnection)this.m_pooledConnection, (S41PreparedStatement)preparedStatement);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement preparedStatement = this.m_connection.prepareStatement(string, n, n2, n3);
            return new S41PreparedStatementHandle((S41PooledConnection)this.m_pooledConnection, (S41PreparedStatement)preparedStatement);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement preparedStatement = this.m_connection.prepareStatement(string, nArray);
            return new S41PreparedStatementHandle((S41PooledConnection)this.m_pooledConnection, (S41PreparedStatement)preparedStatement);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement preparedStatement = this.m_connection.prepareStatement(string, stringArray);
            return new S41PreparedStatementHandle((S41PooledConnection)this.m_pooledConnection, (S41PreparedStatement)preparedStatement);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.m_isClosed) {
            throw (SQLClientInfoException)ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, this.m_connection.getWarningListener(), ExceptionType.CLIENT_INFO, new Object[0]);
        }
        try {
            ((S41Connection)this.m_connection).setClientInfo(properties);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLClientInfoException);
            }
            throw sQLClientInfoException;
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        if (this.m_isClosed) {
            throw (SQLClientInfoException)ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, this.m_connection.getWarningListener(), ExceptionType.CLIENT_INFO, new Object[0]);
        }
        try {
            ((S41Connection)this.m_connection).setClientInfo(string, string2);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLClientInfoException);
            }
            throw sQLClientInfoException;
        }
    }

    @Override
    public void setSchema(String string) throws SQLException {
        this.checkIfOpen();
        try {
            ((S41Connection)this.m_connection).setSchema(string);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkIfOpen();
        try {
            return ((S41Connection)this.m_connection).getSchema();
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.checkIfOpen();
        try {
            ((S41Connection)this.m_connection).abort(executor);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        this.checkIfOpen();
        try {
            ((S41Connection)this.m_connection).setNetworkTimeout(executor, n);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkIfOpen();
        try {
            return ((S41Connection)this.m_connection).getNetworkTimeout();
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }
}

