/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.utilities;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.simba.athena.amazonaws.auth.AWSStaticCredentialsProvider;
import com.simba.athena.amazonaws.auth.BasicAWSCredentials;
import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.shaded.apache.commons.csv.CSVFormat;
import com.simba.athena.shaded.apache.commons.csv.CSVParser;
import com.simba.athena.shaded.apache.commons.csv.CSVRecord;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AJUtilities {
    private static final Pattern RTRIM = Pattern.compile("\\s+$");
    private static final Pattern COMMENT = Pattern.compile("((--)(.)*(\\r\\n|\\n)+(\\s)*)|((\\/\\*)((.|\\r\\n|\\n)*?)(\\*\\/)(\\r\\n|\\n|\\s)*)");

    public static AWSCredentialsProvider createAwsStaticCredentialsProvider(ILogger iLogger, String string, String string2) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        BasicAWSCredentials basicAWSCredentials = new BasicAWSCredentials(string, string2);
        return new AWSStaticCredentialsProvider(basicAWSCredentials);
    }

    public static AWSCredentialsProvider createAwsCredentialsProvider(ILogger iLogger, String string, String string2, String string3, List<String> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        if (null == string3) {
            return AJUtilities.createAwsStaticCredentialsProvider(iLogger, string, string2);
        }
        try {
            Class<AWSCredentialsProvider> clazz = Class.forName(string3).asSubclass(AWSCredentialsProvider.class);
            if (null == list || list.isEmpty()) {
                return clazz.newInstance();
            }
            Class[] classArray = new Class[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                classArray[i] = String.class;
            }
            Constructor<AWSCredentialsProvider> constructor = clazz.getConstructor(classArray);
            return constructor.newInstance(list.toArray());
        }
        catch (Exception exception) {
            ErrorException errorException = AJDriver.s_AJMessages.createGeneralException(AJMessageKey.CREATE_AWS_CREDENTIALS_PROVIDER_ERR.name(), string3);
            errorException.initCause(exception);
            LogUtilities.logError(errorException, iLogger);
            if (null != string && null != string2) {
                return AJUtilities.createAwsStaticCredentialsProvider(iLogger, string, string2);
            }
            throw errorException;
        }
    }

    public static int getStartOfQueryWithComments(String string) throws ErrorException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Matcher matcher = COMMENT.matcher(string);
        while (matcher.find(n)) {
            n3 = matcher.start();
            n4 = matcher.end();
            if (n3 != n2) break;
            if (n4 >= string.length() - 1 || '\n' == string.charAt(n4)) {
                // empty if block
            }
            n = n2 = ++n4;
        }
        if (n > string.length() - 1) {
            throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.COMMENT_PARSING_ERR.name(), string);
        }
        return n;
    }

    public static void parseCellAsTabDelimited(ILogger iLogger, String string, int n, List<String> list) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        String[] stringArray = string.split("\t");
        int n2 = 0;
        while (n2 < stringArray.length) {
            list.add(stringArray[n2]);
            if (n > ++n2) continue;
            return;
        }
        while (n > n2) {
            list.add(null);
            ++n2;
        }
    }

    public static void parseCredentialsProviderArgs(ILogger iLogger, String string, List<String> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        StringReader stringReader = new StringReader(string);
        try {
            CSVParser cSVParser = CSVFormat.DEFAULT.withEscape('\\').withIgnoreSurroundingSpaces(true).parse(stringReader);
            for (CSVRecord cSVRecord : cSVParser) {
                Iterator<String> iterator = cSVRecord.iterator();
                while (iterator.hasNext()) {
                    list.add(iterator.next());
                }
            }
        }
        catch (Exception exception) {
            ErrorException errorException = AJDriver.s_AJMessages.createGeneralException(AJMessageKey.PARSE_AWS_CREDENTIALS_PROVIDER_ARGS_ERR.name(), string);
            errorException.initCause(exception);
            LogUtilities.logError(errorException, iLogger);
            throw errorException;
        }
    }

    public static String rtrim(String string) {
        return RTRIM.matcher(string).replaceAll("");
    }
}

