/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.dataengine;

import com.simba.athena.amazonaws.services.athena.model.ColumnInfo;
import com.simba.athena.amazonaws.services.athena.model.Datum;
import com.simba.athena.amazonaws.services.athena.model.Row;
import com.simba.athena.athena.api.AJClient;
import com.simba.athena.athena.api.AJExecutionContext;
import com.simba.athena.athena.core.AJConnection;
import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.core.AJSettings;
import com.simba.athena.athena.dataengine.AJDoubleBufferManager;
import com.simba.athena.athena.dataengine.AJResultSetBuffer;
import com.simba.athena.athena.dataengine.AJStatementType;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.athena.utilities.AJTypeUtilities;
import com.simba.athena.athena.utilities.AJUtilities;
import com.simba.athena.dsi.dataengine.impl.DSISimpleArray;
import com.simba.athena.dsi.dataengine.impl.DSISimpleResultSet;
import com.simba.athena.dsi.dataengine.interfaces.IColumn;
import com.simba.athena.dsi.dataengine.utilities.ColumnMetadata;
import com.simba.athena.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.athena.dsi.dataengine.utilities.DataWrapper;
import com.simba.athena.dsi.dataengine.utilities.Nullable;
import com.simba.athena.dsi.dataengine.utilities.Searchable;
import com.simba.athena.dsi.dataengine.utilities.TypeMetadata;
import com.simba.athena.dsi.dataengine.utilities.TypeUtilities;
import com.simba.athena.dsi.dataengine.utilities.Updatable;
import com.simba.athena.dsi.exceptions.IncorrectTypeException;
import com.simba.athena.dsi.exceptions.NumericOverflowException;
import com.simba.athena.dsi.exceptions.OperationCanceledException;
import com.simba.athena.shaded.apache.commons.codec.DecoderException;
import com.simba.athena.shaded.apache.commons.codec.binary.Hex;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.Warning;
import com.simba.athena.support.WarningCode;
import com.simba.athena.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class AJResultSet
extends DSISimpleResultSet {
    private AJConnection m_connection;
    private AJClient m_client;
    private final AJSettings m_settings;
    private AJExecutionContext m_execContext;
    private AJDoubleBufferManager m_dbm;
    private AJResultSetBuffer m_resultBuffer = new AJResultSetBuffer();
    private ArrayList<ColumnMetadata> m_columns = new ArrayList();
    private List<Short> m_cachedSqlTypes = new ArrayList<Short>();
    private ListIterator<Row> m_rowIterator;
    private Row m_currentRow;
    private List<String> m_currentRowVals = new ArrayList<String>();
    private final ILogger m_logger;
    private IWarningListener m_warningListener;

    public AJResultSet(ILogger iLogger, IWarningListener iWarningListener, AJConnection aJConnection, AJSettings aJSettings, AJExecutionContext aJExecutionContext, AJStatementType aJStatementType) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_logger = iLogger;
        this.m_warningListener = iWarningListener;
        this.m_connection = aJConnection;
        this.m_client = this.m_connection.getClient();
        this.m_settings = aJSettings;
        this.m_execContext = aJExecutionContext;
        this.m_client.fetchRows(this.m_execContext, this.m_resultBuffer);
        int n = 0;
        if (AJStatementType.SELECT_OR_VALUES_STATEMENT == aJStatementType) {
            n = 1;
        }
        this.m_rowIterator = this.m_resultBuffer.getResultRows().listIterator(n);
        this.initializeColumns();
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, l, l2, dataWrapper);
        short s = this.m_cachedSqlTypes.get(n);
        String string = this.m_currentRowVals.get(n);
        if (null == string) {
            dataWrapper.setNull(s);
            return false;
        }
        switch (s) {
            case 16: {
                dataWrapper.setBoolean(Boolean.valueOf(string));
                return false;
            }
            case -6: {
                dataWrapper.setTinyInt(Short.valueOf(string));
                return false;
            }
            case 5: {
                dataWrapper.setSmallInt(Integer.valueOf(string));
                return false;
            }
            case 4: {
                dataWrapper.setInteger(Long.valueOf(string));
                return false;
            }
            case -5: {
                dataWrapper.setBigInt(new BigInteger(string));
                return false;
            }
            case 7: {
                dataWrapper.setReal(Float.valueOf(string));
                return false;
            }
            case 6: {
                dataWrapper.setFloat(Double.valueOf(string));
                return false;
            }
            case 8: {
                dataWrapper.setDouble(Double.valueOf(string));
                return false;
            }
            case 3: {
                dataWrapper.setDecimal(new BigDecimal(string));
                return false;
            }
            case 91: {
                dataWrapper.setDate(Date.valueOf(string));
                return false;
            }
            case 93: {
                dataWrapper.setTimestamp(Timestamp.valueOf(string));
                return false;
            }
            case -3: {
                byte[] byArray = null;
                Hex hex = new Hex();
                try {
                    byArray = (byte[])hex.decode(string.replaceAll(" ", ""));
                }
                catch (DecoderException decoderException) {
                    throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.VARBINARY_CONVERSION_ERR, decoderException.getMessage());
                }
                return DSITypeUtilities.outputVarBinary(byArray, dataWrapper, l, l2);
            }
            case 1: 
            case 12: {
                try {
                    return DSITypeUtilities.outputString(string, dataWrapper, l, l2, s);
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    LogUtilities.logError(incorrectTypeException, this.m_logger);
                    return false;
                }
            }
            case 2003: {
                if (string.startsWith("[") && string.endsWith("]")) {
                    String[] stringArray = string.substring(1, string.length() - 1).split(", ");
                    DSISimpleArray dSISimpleArray = new DSISimpleArray(stringArray, this.m_columns.get(n));
                    dataWrapper.setArray(dSISimpleArray);
                    return false;
                }
                throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.ARRAY_CONVERSION_ERR, string);
            }
        }
        return false;
    }

    @Override
    public long getRowCount() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return -1L;
    }

    public ArrayList<ColumnMetadata> getSelectColumns() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_columns;
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkCancelFlag();
        if (this.m_settings.m_enableDoubleBuffering) {
            if (null == this.m_dbm) {
                this.m_dbm = new AJDoubleBufferManager(this.m_logger, this.m_settings.m_rowsToFetchPerBlock, this.m_client, this.m_execContext);
                this.m_connection.getThreadPool().execute(this.m_dbm);
            }
            if (!this.m_rowIterator.hasNext()) {
                this.checkCancelFlag();
                if (this.m_dbm.getNextBuffer()) {
                    this.m_rowIterator = this.m_dbm.getDataFromBuffer().listIterator();
                }
            }
        } else if (!this.m_rowIterator.hasNext() && this.m_execContext.m_hasMoreRows) {
            this.checkCancelFlag();
            this.m_client.fetchRows(this.m_execContext, this.m_resultBuffer);
            this.m_rowIterator = this.m_resultBuffer.getResultRows().listIterator();
        }
        return this.m_rowIterator.hasNext();
    }

    @Override
    public boolean hasRowCount() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return false;
    }

    @Override
    protected void doCloseCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.cleanupDoubleBuffer();
    }

    @Override
    protected boolean doMoveToNextRow() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.hasMoreRows()) {
            this.m_currentRow = this.m_rowIterator.next();
            this.parseCurrentRow();
            return true;
        }
        return false;
    }

    private void checkCancelFlag() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.m_client.checkCancelFlag(this.m_execContext);
        }
        catch (OperationCanceledException operationCanceledException) {
            this.cleanupDoubleBuffer();
            throw operationCanceledException;
        }
    }

    private void cleanupDoubleBuffer() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_settings.m_enableDoubleBuffering && null != this.m_dbm) {
            this.m_dbm.stop();
            this.m_dbm = null;
        }
    }

    private void initializeColumns() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        List<ColumnInfo> list = this.m_resultBuffer.getResultSetMetadata().getColumnInfo();
        for (ColumnInfo columnInfo : list) {
            String string = columnInfo.getType();
            string = string.equalsIgnoreCase("varchar") ? AJTypeUtilities.rectifyTypeName(string, columnInfo.getPrecision()) : AJTypeUtilities.rectifyTypeName(string);
            int n = AJTypeUtilities.mapAthenaTypeNameToSqlType(string, this.m_settings);
            TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(n);
            ColumnMetadata columnMetadata = new ColumnMetadata(typeMetadata);
            typeMetadata.setTypeName(string);
            typeMetadata.setLocalTypeName(string);
            if (typeMetadata.isCharacterType()) {
                long l = columnInfo.getPrecision().intValue();
                if (AJTypeUtilities.isComplexType(string)) {
                    l = this.m_settings.m_complexTypeColumnLength;
                }
                if (string.equalsIgnoreCase("string")) {
                    l = this.m_settings.m_stringColumnLength;
                }
                try {
                    columnMetadata.setColumnLength(l);
                }
                catch (NumericOverflowException numericOverflowException) {
                    LogUtilities.logError(numericOverflowException, this.m_logger);
                    throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.GENERAL_ERROR, (Throwable)numericOverflowException);
                }
            } else if (typeMetadata.isBinaryType()) {
                try {
                    columnMetadata.setColumnLength(this.m_settings.m_binaryColumnLength);
                }
                catch (NumericOverflowException numericOverflowException) {
                    LogUtilities.logError(numericOverflowException, this.m_logger);
                    throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.GENERAL_ERROR, (Throwable)numericOverflowException);
                }
            } else if (typeMetadata.isExactNumericType()) {
                int n2 = null == columnInfo.getPrecision() ? 38 : columnInfo.getPrecision();
                int n3 = null == columnInfo.getScale() ? 0 : columnInfo.getScale();
                typeMetadata.setPrecision((short)n2);
                typeMetadata.setScale((short)n3);
            } else if (typeMetadata.isApproximateNumericType()) {
                if (7 == n) {
                    typeMetadata.setPrecision((short)24);
                } else {
                    typeMetadata.setPrecision((short)53);
                }
            } else if (TypeUtilities.isTimeType(n)) {
                typeMetadata.setPrecision((short)3);
            } else if (2003 == n) {
                ArrayList<IColumn> arrayList = new ArrayList<IColumn>();
                TypeMetadata typeMetadata2 = TypeMetadata.createTypeMetadata(12);
                ColumnMetadata columnMetadata2 = new ColumnMetadata(typeMetadata2);
                arrayList.add(columnMetadata2);
                typeMetadata.setNestedColumnList(arrayList);
            }
            columnMetadata.setAutoUnique(false);
            columnMetadata.setCaseSensitive(columnInfo.getCaseSensitive());
            columnMetadata.setCatalogName("AwsDataCatalog");
            columnMetadata.setLabel(columnInfo.getLabel());
            columnMetadata.setName(columnInfo.getName());
            columnMetadata.setNullable(Nullable.NULLABLE);
            columnMetadata.setSchemaName(columnInfo.getSchemaName());
            columnMetadata.setSearchable(Searchable.SEARCHABLE);
            columnMetadata.setTableName(columnInfo.getTableName());
            columnMetadata.setUpdatable(Updatable.READ_ONLY);
            this.m_columns.add(columnMetadata);
            this.m_cachedSqlTypes.add(typeMetadata.getType());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseCurrentRow() throws ErrorException {
        List<Datum> list;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_currentRowVals.clear();
        if (this.m_cachedSqlTypes.isEmpty()) {
            return;
        }
        int n = this.m_cachedSqlTypes.size();
        if (n > (list = this.m_currentRow.getData()).size()) {
            if (1 != list.size() || !this.m_settings.m_parseResultRowsAsTabDelimited) throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.UNEXPECTED_NUM_RESULT_COLUMNS, new String[]{String.valueOf(list.size()), String.valueOf(n)});
            this.postUnexpectedNumColsWarning();
            AJUtilities.parseCellAsTabDelimited(this.m_logger, list.get(0).getVarCharValue(), n, this.m_currentRowVals);
            return;
        } else if (n < list.size()) {
            this.postUnexpectedNumColsWarning();
            return;
        } else {
            for (Datum datum : list) {
                this.m_currentRowVals.add(datum.getVarCharValue());
            }
        }
    }

    private void postUnexpectedNumColsWarning() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_settings.m_suppressWarningDuringFetch) {
            LogUtilities.logWarning("Server returned " + this.m_currentRow.getData().size() + " columns for the current result set block but " + this.m_cachedSqlTypes.size() + " columns are expected.", this.m_logger);
        } else {
            this.m_warningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, AJMessageKey.UNEXPECTED_NUM_RESULT_COLUMNS.name(), new String[]{String.valueOf(this.m_currentRow.getData().size()), String.valueOf(this.m_cachedSqlTypes.size())}));
        }
    }
}

