/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.http.apache.utils;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.http.settings.HttpClientSettings;
import com.simba.athena.amazonaws.util.FakeIOException;
import com.simba.athena.shaded.apache.http.HttpEntity;
import com.simba.athena.shaded.apache.http.HttpHost;
import com.simba.athena.shaded.apache.http.auth.AuthScope;
import com.simba.athena.shaded.apache.http.auth.Credentials;
import com.simba.athena.shaded.apache.http.auth.NTCredentials;
import com.simba.athena.shaded.apache.http.client.CredentialsProvider;
import com.simba.athena.shaded.apache.http.client.protocol.HttpClientContext;
import com.simba.athena.shaded.apache.http.entity.BufferedHttpEntity;
import com.simba.athena.shaded.apache.http.entity.StringEntity;
import com.simba.athena.shaded.apache.http.impl.auth.BasicScheme;
import com.simba.athena.shaded.apache.http.impl.client.BasicAuthCache;
import com.simba.athena.shaded.apache.http.impl.client.BasicCredentialsProvider;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public class ApacheUtils {
    public static HttpEntity newStringEntity(String s) {
        try {
            return new StringEntity(s);
        }
        catch (UnsupportedEncodingException e) {
            throw new SdkClientException("Unable to create HTTP entity: " + e.getMessage(), e);
        }
    }

    public static HttpEntity newBufferedHttpEntity(HttpEntity entity) throws FakeIOException {
        try {
            return new BufferedHttpEntity(entity);
        }
        catch (FakeIOException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SdkClientException("Unable to create HTTP entity: " + e.getMessage(), e);
        }
    }

    public static HttpClientContext newClientContext(HttpClientSettings settings, Map<String, ? extends Object> attributes) {
        HttpClientContext clientContext = new HttpClientContext();
        if (attributes != null && !attributes.isEmpty()) {
            for (Map.Entry<String, ? extends Object> entry : attributes.entrySet()) {
                clientContext.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        ApacheUtils.addPreemptiveAuthenticationProxy(clientContext, settings);
        return clientContext;
    }

    public static CredentialsProvider newProxyCredentialsProvider(HttpClientSettings settings) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(ApacheUtils.newAuthScope(settings), ApacheUtils.newNTCredentials(settings));
        return provider;
    }

    private static Credentials newNTCredentials(HttpClientSettings settings) {
        return new NTCredentials(settings.getProxyUsername(), settings.getProxyPassword(), settings.getProxyWorkstation(), settings.getProxyDomain());
    }

    private static AuthScope newAuthScope(HttpClientSettings settings) {
        return new AuthScope(settings.getProxyHost(), settings.getProxyPort());
    }

    private static void addPreemptiveAuthenticationProxy(HttpClientContext clientContext, HttpClientSettings settings) {
        if (settings.isPreemptiveBasicProxyAuth()) {
            HttpHost targetHost = new HttpHost(settings.getProxyHost(), settings.getProxyPort());
            CredentialsProvider credsProvider = ApacheUtils.newProxyCredentialsProvider(settings);
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(targetHost, basicAuth);
            clientContext.setCredentialsProvider(credsProvider);
            clientContext.setAuthCache(authCache);
        }
    }
}

