/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.auth.internal;

import com.simba.athena.amazonaws.SignableRequest;
import com.simba.athena.amazonaws.auth.SdkClock;
import com.simba.athena.amazonaws.auth.internal.AWS4SignerUtils;
import com.simba.athena.amazonaws.util.AwsHostNameUtils;
import java.util.Date;

public final class AWS4SignerRequestParams {
    private final SignableRequest<?> request;
    private final long signingDateTimeMilli;
    private final String scope;
    private final String regionName;
    private final String serviceName;
    private final String formattedSigningDateTime;
    private final String formattedSigningDate;
    private final String signingAlgorithm;

    public AWS4SignerRequestParams(SignableRequest<?> request, Date signingDateOverride, String regionNameOverride, String serviceName, String signingAlgorithm) {
        this(request, signingDateOverride, regionNameOverride, serviceName, signingAlgorithm, null);
    }

    public AWS4SignerRequestParams(SignableRequest<?> request, Date signingDateOverride, String regionNameOverride, String serviceName, String signingAlgorithm, String endpointPrefix) {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (signingAlgorithm == null) {
            throw new IllegalArgumentException("Signing Algorithm cannot be null");
        }
        this.request = request;
        this.signingDateTimeMilli = signingDateOverride != null ? signingDateOverride.getTime() : this.getSigningDate(request);
        this.formattedSigningDate = AWS4SignerUtils.formatDateStamp(this.signingDateTimeMilli);
        this.serviceName = serviceName;
        this.regionName = regionNameOverride != null ? regionNameOverride : this.resolveRegion(endpointPrefix, this.serviceName);
        this.scope = this.generateScope(request, this.formattedSigningDate, this.serviceName, this.regionName);
        this.formattedSigningDateTime = AWS4SignerUtils.formatTimestamp(this.signingDateTimeMilli);
        this.signingAlgorithm = signingAlgorithm;
    }

    private String resolveRegion(String endpointPrefix, String serviceSigningName) {
        return AwsHostNameUtils.parseRegionName(this.request.getEndpoint().getHost(), endpointPrefix != null ? endpointPrefix : serviceSigningName);
    }

    private final long getSigningDate(SignableRequest<?> request) {
        return SdkClock.Instance.get().currentTimeMillis() - (long)request.getTimeOffset() * 1000L;
    }

    private String generateScope(SignableRequest<?> request, String dateStamp, String serviceName, String regionName) {
        StringBuilder scopeBuilder = new StringBuilder();
        return scopeBuilder.append(dateStamp).append("/").append(regionName).append("/").append(serviceName).append("/").append("aws4_request").toString();
    }

    public SignableRequest<?> getRequest() {
        return this.request;
    }

    public String getScope() {
        return this.scope;
    }

    public String getFormattedSigningDateTime() {
        return this.formattedSigningDateTime;
    }

    public long getSigningDateTimeMilli() {
        return this.signingDateTimeMilli;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getFormattedSigningDate() {
        return this.formattedSigningDate;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }
}

