/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.auth;

import com.amazonaws.auth.AWSSessionCredentials;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.annotation.ThreadSafe;
import com.simba.athena.amazonaws.auth.BasicSessionCredentials;
import com.simba.athena.amazonaws.services.securitytoken.model.Credentials;
import java.util.Date;

@ThreadSafe
@SdkInternalApi
final class SessionCredentialsHolder {
    private final AWSSessionCredentials sessionCredentials;
    private final Date sessionCredentialsExpiration;

    SessionCredentialsHolder(Credentials credentials) {
        this.sessionCredentials = new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
        this.sessionCredentialsExpiration = credentials.getExpiration();
    }

    public AWSSessionCredentials getSessionCredentials() {
        return this.sessionCredentials;
    }

    public Date getSessionCredentialsExpiration() {
        return this.sessionCredentialsExpiration;
    }
}

