/*
 * Decompiled with CFR 0.152.
 */
package com.sylversky.indexablelistview.section;

import com.sylversky.indexablelistview.scroller.Indexer;
import com.sylversky.indexablelistview.scroller.StringMatcher;
import com.sylversky.indexablelistview.section.Section;

public class AlphabetSection
extends Section {
    private String mSections = "#ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public AlphabetSection(Indexer indexer) {
        super(indexer);
    }

    @Override
    public Object[] getArraySections() {
        Object[] sections = new String[this.mSections.length()];
        for (int i = 0; i < this.mSections.length(); ++i) {
            sections[i] = String.valueOf(this.mSections.charAt(i));
        }
        return sections;
    }

    @Override
    public int getPositionForSection(int section, int totalComponent) {
        for (int j = 0; j < totalComponent; ++j) {
            if (section == 0) {
                for (int k = 0; k <= 9; ++k) {
                    String value = this.getIndexer().getComponentName(j).toUpperCase();
                    if (!StringMatcher.match(String.valueOf(value.charAt(0)), String.valueOf(k))) continue;
                    return j;
                }
                continue;
            }
            String value = this.getIndexer().getComponentName(j).toUpperCase();
            if (!StringMatcher.match(String.valueOf(value.charAt(0)), String.valueOf(this.mSections.charAt(section)))) continue;
            return j;
        }
        return -1;
    }
}

