/*
 * Decompiled with CFR 0.152.
 */
package com.sylversky.indexablelistview.scroller;

public class StringMatcher {
    private static final char KOREAN_UNICODE_START = '\uac00';
    private static final char KOREAN_UNICODE_END = '\ud7a3';
    private static final char KOREAN_UNIT = '\u024c';
    private static final char[] KOREAN_INITIAL = new char[]{'\u3131', '\u3132', '\u3134', '\u3137', '\u3138', '\u3139', '\u3141', '\u3142', '\u3143', '\u3145', '\u3146', '\u3147', '\u3148', '\u3149', '\u314a', '\u314b', '\u314c', '\u314d', '\u314e'};

    public static boolean match(String value, String keyword) {
        if (value == null || keyword == null) {
            return false;
        }
        if (keyword.length() > value.length()) {
            return false;
        }
        int i = 0;
        int j = 0;
        do {
            if (StringMatcher.isKorean(value.charAt(i)) && StringMatcher.isInitialSound(keyword.charAt(j))) {
                if (keyword.charAt(j) == StringMatcher.getInitialSound(value.charAt(i))) {
                    ++i;
                    ++j;
                    continue;
                }
                if (j > 0) break;
                ++i;
                continue;
            }
            if (keyword.charAt(j) == value.charAt(i)) {
                ++i;
                ++j;
                continue;
            }
            if (j > 0) break;
            ++i;
        } while (i < value.length() && j < keyword.length());
        return j == keyword.length();
    }

    private static boolean isKorean(char c) {
        return c >= '\uac00' && c <= '\ud7a3';
    }

    private static boolean isInitialSound(char c) {
        for (char i : KOREAN_INITIAL) {
            if (c != i) continue;
            return true;
        }
        return false;
    }

    private static char getInitialSound(char c) {
        if (!StringMatcher.isKorean(c)) {
            return c;
        }
        return KOREAN_INITIAL[(c - 44032) / 588];
    }
}

