/*
 * Decompiled with CFR 0.152.
 */
package com.sylversky.indexablelistview.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.sylversky.indexablelistview.scroller.RecyclerViewIndexScroller;

public class IndexableRecyclerView
extends RecyclerView {
    private RecyclerViewIndexScroller mScroller;
    private boolean invisible;
    RecyclerView.ItemDecoration itemDecoration = new RecyclerView.ItemDecoration(){

        public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
            super.onDrawOver(c, parent, state);
            IndexableRecyclerView.this.mScroller.draw(c);
        }
    };

    public IndexableRecyclerView(Context context) {
        super(context);
        this.init();
    }

    public IndexableRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public IndexableRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public void init() {
        this.mScroller = new RecyclerViewIndexScroller(this.getContext(), this);
        this.addItemDecoration(this.itemDecoration);
    }

    public void setInvisibleIndexer(boolean invisibleIndexer) {
        this.invisible = invisibleIndexer;
        this.mScroller.setInvisible(invisibleIndexer);
    }

    public void setIndexTypeface(Typeface typeface) {
        this.mScroller.setDefaultTypeface(typeface);
    }

    public boolean onTouchEvent(MotionEvent e) {
        return this.mScroller.onTouchEvent(e) || super.onTouchEvent(e);
    }

    public boolean fling(int velocityX, int velocityY) {
        this.mScroller.show();
        return super.fling(velocityX, velocityY);
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        return this.mScroller.contains(e.getX(), e.getY()) || super.onInterceptTouchEvent(e);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        super.setAdapter(adapter);
        this.mScroller.setAdapter(adapter);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mScroller.onSizeChanged(w, h, oldw, oldh);
        if (this.getChildCount() > 0 && !this.invisible) {
            if (h < oldh) {
                this.mScroller.setInvisible(true);
            } else {
                this.mScroller.setInvisible(false);
            }
        }
    }
}

