/*
 * Decompiled with CFR 0.152.
 */
package com.sylversky.indexablelistview.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.widget.Adapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.sylversky.indexablelistview.scroller.ListViewIndexScroller;

public class IndexableListView
extends ListView {
    private ListViewIndexScroller mScroller = null;
    private GestureDetector mGestureDetector = null;
    private boolean invisible;

    public IndexableListView(Context context) {
        super(context);
        this.init();
    }

    public IndexableListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public IndexableListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.setFastScrollEnabled(true);
    }

    public void setInvisibleIndexer(boolean invisibleIndexer) {
        this.invisible = invisibleIndexer;
        this.mScroller.setInvisible(invisibleIndexer);
    }

    public void setIndexTypeface(Typeface typeface) {
        this.mScroller.setDefaultTypeface(typeface);
    }

    public void setFastScrollEnabled(boolean enabled) {
        super.setFastScrollEnabled(enabled);
        if (enabled) {
            this.mScroller = new ListViewIndexScroller(this.getContext(), this);
        } else if (this.mScroller != null) {
            this.mScroller.hide();
            this.mScroller = null;
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mScroller != null) {
            this.mScroller.draw(canvas);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mScroller != null && this.mScroller.onTouchEvent(ev)) {
            return true;
        }
        if (this.mGestureDetector == null) {
            this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

                public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                    if (IndexableListView.this.mScroller != null) {
                        IndexableListView.this.mScroller.show();
                    }
                    return super.onFling(e1, e2, velocityX, velocityY);
                }
            });
        }
        this.mGestureDetector.onTouchEvent(ev);
        return super.onTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mScroller != null) {
            return this.mScroller.contains(ev.getX(), ev.getY()) || super.onInterceptTouchEvent(ev);
        }
        return super.onInterceptTouchEvent(ev);
    }

    public void setAdapter(ListAdapter adapter) {
        super.setAdapter(adapter);
        if (this.mScroller != null) {
            this.mScroller.setAdapter((Adapter)adapter);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mScroller != null) {
            this.mScroller.onSizeChanged(w, h, oldw, oldh);
            if (this.getChildCount() > 0 && !this.invisible) {
                if (h < oldh) {
                    this.mScroller.setInvisible(true);
                } else {
                    this.mScroller.setInvisible(false);
                }
            }
        }
    }
}

