/*
 * Decompiled with CFR 0.152.
 */
package com.sylversky.indexablelistview.scroller;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.widget.SectionIndexer;
import com.sylversky.indexablelistview.scroller.Indexer;

abstract class IndexScroller {
    private float mIndexbarWidth;
    private float mIndexbarMargin;
    private float mPreviewPadding;
    private float mDensity;
    private float mScaledDensity;
    private float mAlphaRate;
    private int mState = 0;
    private int mListViewWidth;
    private int mListViewHeight;
    private int mCurrentSection = -1;
    private boolean mIsIndexing = false;
    private SectionIndexer mIndexer = null;
    private String[] mSections = null;
    private RectF mIndexbarRect;
    private boolean invisible;
    private Typeface defaultTypeface;
    private static final int STATE_HIDDEN = 0;
    private static final int STATE_SHOWING = 1;
    private static final int STATE_SHOWN = 2;
    private static final int STATE_HIDING = 3;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (IndexScroller.this.mState) {
                case 1: {
                    IndexScroller.this.mAlphaRate = (float)((double)IndexScroller.this.mAlphaRate + (double)(1.0f - IndexScroller.this.mAlphaRate) * 0.2);
                    if ((double)IndexScroller.this.mAlphaRate > 0.9) {
                        IndexScroller.this.mAlphaRate = 1.0f;
                        IndexScroller.this.setState(2);
                    }
                    IndexScroller.this.invalidate();
                    IndexScroller.this.fade(10L);
                    break;
                }
                case 2: {
                    IndexScroller.this.setState(3);
                    break;
                }
                case 3: {
                    IndexScroller.this.mAlphaRate = (float)((double)IndexScroller.this.mAlphaRate - (double)IndexScroller.this.mAlphaRate * 0.2);
                    if ((double)IndexScroller.this.mAlphaRate < 0.1) {
                        IndexScroller.this.mAlphaRate = 0.0f;
                        IndexScroller.this.setState(0);
                    }
                    IndexScroller.this.invalidate();
                    IndexScroller.this.fade(10L);
                }
            }
        }
    };

    protected abstract void setSelection(int var1);

    protected abstract void invalidate();

    IndexScroller(Context context) {
        this.mDensity = context.getResources().getDisplayMetrics().density;
        this.mScaledDensity = context.getResources().getDisplayMetrics().scaledDensity;
        this.mIndexbarWidth = 20.0f * this.mDensity;
        this.mIndexbarMargin = 10.0f * this.mDensity;
        this.mPreviewPadding = 5.0f * this.mDensity;
    }

    public void draw(Canvas canvas) {
        if (this.mState == 0 || this.invisible) {
            return;
        }
        Paint indexbarPaint = new Paint();
        indexbarPaint.setColor(-16777216);
        indexbarPaint.setAlpha((int)(64.0f * this.mAlphaRate));
        indexbarPaint.setAntiAlias(true);
        canvas.drawRoundRect(this.mIndexbarRect, 5.0f * this.mDensity, 5.0f * this.mDensity, indexbarPaint);
        if (this.mSections != null && this.mSections.length > 0) {
            if (this.mCurrentSection >= 0) {
                Paint previewPaint = new Paint();
                previewPaint.setColor(-16777216);
                previewPaint.setAlpha(96);
                previewPaint.setAntiAlias(true);
                previewPaint.setShadowLayer(3.0f, 0.0f, 0.0f, Color.argb((int)64, (int)0, (int)0, (int)0));
                Paint previewTextPaint = new Paint();
                previewTextPaint.setColor(-1);
                previewTextPaint.setAntiAlias(true);
                previewTextPaint.setTextSize(50.0f * this.mScaledDensity);
                if (this.defaultTypeface != null) {
                    previewTextPaint.setTypeface(this.defaultTypeface);
                }
                float previewTextWidth = previewTextPaint.measureText(this.mSections[this.mCurrentSection]);
                float previewSize = 2.0f * this.mPreviewPadding + previewTextPaint.descent() - previewTextPaint.ascent();
                RectF previewRect = new RectF(((float)this.mListViewWidth - previewSize) / 2.0f, ((float)this.mListViewHeight - previewSize) / 2.0f, ((float)this.mListViewWidth - previewSize) / 2.0f + previewSize, ((float)this.mListViewHeight - previewSize) / 2.0f + previewSize);
                canvas.drawRoundRect(previewRect, 5.0f * this.mDensity, 5.0f * this.mDensity, previewPaint);
                canvas.drawText(this.mSections[this.mCurrentSection], previewRect.left + (previewSize - previewTextWidth) / 2.0f - 1.0f, previewRect.top + this.mPreviewPadding - previewTextPaint.ascent() + 1.0f, previewTextPaint);
            }
            Paint indexPaint = new Paint();
            indexPaint.setColor(-1);
            indexPaint.setAlpha((int)(255.0f * this.mAlphaRate));
            indexPaint.setAntiAlias(true);
            indexPaint.setTextSize(12.0f * this.mScaledDensity);
            if (this.defaultTypeface != null) {
                indexPaint.setTypeface(this.defaultTypeface);
            }
            float sectionHeight = (this.mIndexbarRect.height() - 2.0f * this.mIndexbarMargin) / (float)this.mSections.length;
            float paddingTop = (sectionHeight - (indexPaint.descent() - indexPaint.ascent())) / 2.0f;
            for (int i = 0; i < this.mSections.length; ++i) {
                float paddingLeft = (this.mIndexbarWidth - indexPaint.measureText(this.mSections[i])) / 2.0f;
                canvas.drawText(this.mSections[i], this.mIndexbarRect.left + paddingLeft, this.mIndexbarRect.top + this.mIndexbarMargin + sectionHeight * (float)i + paddingTop - indexPaint.ascent(), indexPaint);
            }
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.invisible) {
            return false;
        }
        switch (ev.getAction()) {
            case 0: {
                if (this.mState == 0 || !this.contains(ev.getX(), ev.getY())) break;
                this.setState(2);
                this.mIsIndexing = true;
                this.mCurrentSection = this.getSectionByPoint(ev.getY());
                this.setSelection(this.mIndexer.getPositionForSection(this.mCurrentSection));
                return true;
            }
            case 2: {
                if (!this.mIsIndexing) break;
                if (this.contains(ev.getX(), ev.getY())) {
                    this.mCurrentSection = this.getSectionByPoint(ev.getY());
                    this.setSelection(this.mIndexer.getPositionForSection(this.mCurrentSection));
                }
                return true;
            }
            case 1: {
                if (this.mIsIndexing) {
                    this.mIsIndexing = false;
                    this.mCurrentSection = -1;
                }
                if (this.mState != 2) break;
                this.setState(3);
            }
        }
        return false;
    }

    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mListViewWidth = w;
        this.mListViewHeight = h;
        this.mIndexbarRect = new RectF((float)w - this.mIndexbarMargin - this.mIndexbarWidth, this.mIndexbarMargin, (float)w - this.mIndexbarMargin, (float)h - this.mIndexbarMargin);
    }

    public void show() {
        if (this.mState == 0) {
            this.setState(1);
        } else if (this.mState == 3) {
            this.setState(3);
        }
    }

    public void hide() {
        if (this.mState == 2) {
            this.setState(3);
        }
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
        if (invisible) {
            this.setState(0);
        } else {
            this.setState(3);
        }
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public void setDefaultTypeface(Typeface defaultTypeface) {
        this.defaultTypeface = defaultTypeface;
    }

    public void setAdapter(Indexer adapter) {
        this.mIndexer = adapter;
        this.mSections = (String[])this.mIndexer.getSections();
    }

    private void setState(int state) {
        if (state < 0 || state > 3) {
            return;
        }
        this.mState = state;
        switch (this.mState) {
            case 0: {
                this.mHandler.removeMessages(0);
                break;
            }
            case 1: {
                this.mAlphaRate = 0.0f;
                this.fade(0L);
                break;
            }
            case 2: {
                this.mHandler.removeMessages(0);
                break;
            }
            case 3: {
                this.mAlphaRate = 1.0f;
                this.fade(3000L);
            }
        }
    }

    public boolean contains(float x, float y) {
        return x >= this.mIndexbarRect.left && y >= this.mIndexbarRect.top && y <= this.mIndexbarRect.top + this.mIndexbarRect.height();
    }

    private int getSectionByPoint(float y) {
        if (this.mSections == null || this.mSections.length == 0) {
            return 0;
        }
        if (y < this.mIndexbarRect.top + this.mIndexbarMargin) {
            return 0;
        }
        if (y >= this.mIndexbarRect.top + this.mIndexbarRect.height() - this.mIndexbarMargin) {
            return this.mSections.length - 1;
        }
        return (int)((y - this.mIndexbarRect.top - this.mIndexbarMargin) / ((this.mIndexbarRect.height() - 2.0f * this.mIndexbarMargin) / (float)this.mSections.length));
    }

    private void fade(long delay) {
        this.mHandler.removeMessages(0);
        this.mHandler.sendEmptyMessageAtTime(0, SystemClock.uptimeMillis() + delay);
    }
}

