/*
 * Decompiled with CFR 0.152.
 */
package com.sygic.maps.uikit.views.common.extensions;

import android.content.ActivityNotFoundException;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.location.LocationManager;
import android.net.Uri;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Toast;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.appcompat.app.AppCompatActivity;
import com.sygic.maps.uikit.views.R;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\t\u001a\u001e\u0010\r\u001a\u00020\u000e*\u00020\u00022\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010\u0013\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015\u001a*\u0010\u0016\u001a\u00020\u0010*\u00020\u00022\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0012H\u0007\u001a(\u0010\u001a\u001a\u00020\u0015*\u00020\u00022\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0012\u001a\u0019\u0010\u001b\u001a\u0004\u0018\u00010\u0012*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001e\u001a\n\u0010\u001f\u001a\u00020\u0012*\u00020\u0002\u001a\u0014\u0010 \u001a\u00020\u000e*\u00020\u00022\b\b\u0001\u0010\u0014\u001a\u00020\u0010\u001a\u0012\u0010 \u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u001a\u0010!\u001a\u00020\u000e*\u00020\u00022\u000e\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0#\u001a \u0010%\u001a\u00020\u000e*\u00020\u00022\u0006\u0010&\u001a\u00020\u00152\f\b\u0002\u0010'\u001a\u00020(\"\u00020\u0010\u001a \u0010)\u001a\u00020\u000e*\u00020\u00022\u0006\u0010*\u001a\u00020\u00152\f\b\u0002\u0010'\u001a\u00020(\"\u00020\u0010\u001a \u0010+\u001a\u00020\u000e*\u00020\u00022\u0006\u0010,\u001a\u00020\u00152\f\b\u0002\u0010'\u001a\u00020(\"\u00020\u0010\u001a\u0014\u0010-\u001a\u00020\u000e*\u00020\u00022\b\b\u0001\u0010\u0014\u001a\u00020\u0010\u001a\u0012\u0010-\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0019\u0010.\u001a\u0004\u0018\u00010\u0012*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001e\u001a\u0011\u0010/\u001a\u0004\u0018\u00010\u000e*\u00020\u0002\u00a2\u0006\u0002\u00100\"\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u00061"}, d2={"clipboardManager", "Landroid/content/ClipboardManager;", "Landroid/content/Context;", "getClipboardManager", "(Landroid/content/Context;)Landroid/content/ClipboardManager;", "inputMethodManager", "Landroid/view/inputmethod/InputMethodManager;", "getInputMethodManager", "(Landroid/content/Context;)Landroid/view/inputmethod/InputMethodManager;", "locationManager", "Landroid/location/LocationManager;", "getLocationManager", "(Landroid/content/Context;)Landroid/location/LocationManager;", "applyStyle", "", "resId", "", "force", "", "copyToClipboard", "text", "", "getColorFromAttr", "typedValue", "Landroid/util/TypedValue;", "resolveRefs", "getStringFromAttr", "hideKeyboard", "view", "Landroid/view/View;", "(Landroid/content/Context;Landroid/view/View;)Ljava/lang/Boolean;", "isRtl", "longToast", "openActivity", "targetClass", "Ljava/lang/Class;", "Landroidx/appcompat/app/AppCompatActivity;", "openEmail", "mailto", "flags", "", "openPhone", "phoneNumber", "openUrl", "url", "shortToast", "showKeyboard", "toggleKeyboard", "(Landroid/content/Context;)Lkotlin/Unit;", "uikit-views-2.3.0_release"})
public final class ContextExtensionsKt {
    @Nullable
    public static final LocationManager getLocationManager(@NotNull Context $this$locationManager) {
        int $i$f$getLocationManager = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$locationManager, (String)"$this$locationManager");
        Object object = $this$locationManager.getSystemService("location");
        if (!(object instanceof LocationManager)) {
            object = null;
        }
        return (LocationManager)object;
    }

    @Nullable
    public static final ClipboardManager getClipboardManager(@NotNull Context $this$clipboardManager) {
        int $i$f$getClipboardManager = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$clipboardManager, (String)"$this$clipboardManager");
        Object object = $this$clipboardManager.getSystemService("clipboard");
        if (!(object instanceof ClipboardManager)) {
            object = null;
        }
        return (ClipboardManager)object;
    }

    @Nullable
    public static final InputMethodManager getInputMethodManager(@NotNull Context $this$inputMethodManager) {
        int $i$f$getInputMethodManager = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$inputMethodManager, (String)"$this$inputMethodManager");
        Object object = $this$inputMethodManager.getSystemService("input_method");
        if (!(object instanceof InputMethodManager)) {
            object = null;
        }
        return (InputMethodManager)object;
    }

    public static final void applyStyle(@NotNull Context $this$applyStyle, @StyleRes int resId, boolean force) {
        Intrinsics.checkParameterIsNotNull((Object)$this$applyStyle, (String)"$this$applyStyle");
        $this$applyStyle.getTheme().applyStyle(resId, force);
    }

    public static /* synthetic */ void applyStyle$default(Context context, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        ContextExtensionsKt.applyStyle(context, n, bl);
    }

    @ColorInt
    public static final int getColorFromAttr(@NotNull Context $this$getColorFromAttr, @AttrRes int resId, @NotNull TypedValue typedValue, boolean resolveRefs) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getColorFromAttr, (String)"$this$getColorFromAttr");
        Intrinsics.checkParameterIsNotNull((Object)typedValue, (String)"typedValue");
        TypedValue typedValue2 = typedValue;
        boolean bl = false;
        boolean bl2 = false;
        TypedValue it = typedValue2;
        boolean bl3 = false;
        $this$getColorFromAttr.getTheme().resolveAttribute(resId, it, resolveRefs);
        return it.data;
    }

    public static /* synthetic */ int getColorFromAttr$default(Context context, int n, TypedValue typedValue, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            typedValue = new TypedValue();
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return ContextExtensionsKt.getColorFromAttr(context, n, typedValue, bl);
    }

    @NotNull
    public static final String getStringFromAttr(@NotNull Context $this$getStringFromAttr, @AttrRes int resId, @NotNull TypedValue typedValue, boolean resolveRefs) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getStringFromAttr, (String)"$this$getStringFromAttr");
        Intrinsics.checkParameterIsNotNull((Object)typedValue, (String)"typedValue");
        TypedValue typedValue2 = typedValue;
        boolean bl = false;
        boolean bl2 = false;
        TypedValue it = typedValue2;
        boolean bl3 = false;
        $this$getStringFromAttr.getTheme().resolveAttribute(resId, it, resolveRefs);
        if (it.type == 3 && it.string != null) {
            return ((Object)it.string).toString();
        }
        return "";
    }

    public static /* synthetic */ String getStringFromAttr$default(Context context, int n, TypedValue typedValue, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            typedValue = new TypedValue();
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return ContextExtensionsKt.getStringFromAttr(context, n, typedValue, bl);
    }

    public static final void openActivity(@NotNull Context $this$openActivity, @NotNull Class<? extends AppCompatActivity> targetClass) {
        Intrinsics.checkParameterIsNotNull((Object)$this$openActivity, (String)"$this$openActivity");
        Intrinsics.checkParameterIsNotNull(targetClass, (String)"targetClass");
        $this$openActivity.startActivity(new Intent($this$openActivity, targetClass));
    }

    public static final boolean isRtl(@NotNull Context $this$isRtl) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isRtl, (String)"$this$isRtl");
        Resources resources = $this$isRtl.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"this.resources");
        Configuration configuration = resources.getConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"this.resources.configuration");
        return configuration.getLayoutDirection() == 1;
    }

    public static final void openUrl(@NotNull Context $this$openUrl, @NotNull String url, int ... flags) {
        Intrinsics.checkParameterIsNotNull((Object)$this$openUrl, (String)"$this$openUrl");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)flags, (String)"flags");
        if (!TextUtils.isEmpty((CharSequence)url)) {
            String parsedUrl = url;
            if (!StringsKt.startsWith$default((String)url, (String)"http://", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)url, (String)"https://", (boolean)false, (int)2, null)) {
                parsedUrl = "http://" + url;
            }
            try {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)parsedUrl));
                Context context = $this$openUrl;
                boolean bl = false;
                boolean bl2 = false;
                Intent $this$apply = intent;
                boolean bl3 = false;
                int[] $this$forEach$iv = flags;
                boolean $i$f$forEach = false;
                int[] nArray = $this$forEach$iv;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int element$iv;
                    int it = element$iv = nArray[i];
                    boolean bl4 = false;
                    $this$apply.addFlags(it);
                }
                Intent intent2 = intent;
                context.startActivity(intent2);
            }
            catch (ActivityNotFoundException e) {
                ContextExtensionsKt.longToast($this$openUrl, R.string.no_browser_client);
            }
        }
    }

    public static /* synthetic */ void openUrl$default(Context context, String string, int[] nArray, int n, Object object) {
        if ((n & 2) != 0) {
            nArray = new int[]{};
        }
        ContextExtensionsKt.openUrl(context, string, nArray);
    }

    public static final void openEmail(@NotNull Context $this$openEmail, @NotNull String mailto, int ... flags) {
        Intrinsics.checkParameterIsNotNull((Object)$this$openEmail, (String)"$this$openEmail");
        Intrinsics.checkParameterIsNotNull((Object)mailto, (String)"mailto");
        Intrinsics.checkParameterIsNotNull((Object)flags, (String)"flags");
        if (!TextUtils.isEmpty((CharSequence)mailto)) {
            Intent emailIntent = new Intent("android.intent.action.SENDTO");
            emailIntent.setData(Uri.parse((String)("mailto:" + mailto)));
            emailIntent.putExtra("android.intent.extra.EMAIL", new String[]{mailto});
            emailIntent.addFlags(0x10000000);
            try {
                Intent intent = Intent.createChooser((Intent)emailIntent, (CharSequence)$this$openEmail.getString(R.string.send_email));
                Context context = $this$openEmail;
                boolean bl = false;
                boolean bl2 = false;
                Intent $this$apply = intent;
                boolean bl3 = false;
                int[] $this$forEach$iv = flags;
                boolean $i$f$forEach = false;
                int[] nArray = $this$forEach$iv;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int element$iv;
                    int it = element$iv = nArray[i];
                    boolean bl4 = false;
                    $this$apply.addFlags(it);
                }
                Intent intent2 = intent;
                context.startActivity(intent2);
            }
            catch (ActivityNotFoundException e) {
                ContextExtensionsKt.longToast($this$openEmail, R.string.no_email_client);
            }
        }
    }

    public static /* synthetic */ void openEmail$default(Context context, String string, int[] nArray, int n, Object object) {
        if ((n & 2) != 0) {
            nArray = new int[]{};
        }
        ContextExtensionsKt.openEmail(context, string, nArray);
    }

    public static final void openPhone(@NotNull Context $this$openPhone, @NotNull String phoneNumber, int ... flags) {
        Intrinsics.checkParameterIsNotNull((Object)$this$openPhone, (String)"$this$openPhone");
        Intrinsics.checkParameterIsNotNull((Object)phoneNumber, (String)"phoneNumber");
        Intrinsics.checkParameterIsNotNull((Object)flags, (String)"flags");
        if (!TextUtils.isEmpty((CharSequence)phoneNumber)) {
            Intent phoneIntent = new Intent("android.intent.action.DIAL");
            phoneIntent.setData(Uri.parse((String)("tel:" + phoneNumber)));
            try {
                Intent intent = Intent.createChooser((Intent)phoneIntent, null);
                Context context = $this$openPhone;
                boolean bl = false;
                boolean bl2 = false;
                Intent $this$apply = intent;
                boolean bl3 = false;
                int[] $this$forEach$iv = flags;
                boolean $i$f$forEach = false;
                int[] nArray = $this$forEach$iv;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int element$iv;
                    int it = element$iv = nArray[i];
                    boolean bl4 = false;
                    $this$apply.addFlags(it);
                }
                Intent intent2 = intent;
                context.startActivity(intent2);
            }
            catch (ActivityNotFoundException e) {
                ContextExtensionsKt.longToast($this$openPhone, R.string.no_phone_client);
            }
        }
    }

    public static /* synthetic */ void openPhone$default(Context context, String string, int[] nArray, int n, Object object) {
        if ((n & 2) != 0) {
            nArray = new int[]{};
        }
        ContextExtensionsKt.openPhone(context, string, nArray);
    }

    public static final void copyToClipboard(@NotNull Context $this$copyToClipboard, @NotNull String text) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)$this$copyToClipboard, (String)"$this$copyToClipboard");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Context $this$clipboardManager$iv = $this$copyToClipboard;
            boolean $i$f$getClipboardManager = false;
            Object object = $this$clipboardManager$iv.getSystemService("clipboard");
            if (!(object instanceof ClipboardManager)) {
                object = null;
            }
            ClipboardManager clipboardManager = (ClipboardManager)object;
            if (clipboardManager == null) break block1;
            ClipboardManager clipboardManager2 = clipboardManager;
            boolean bl = false;
            boolean bl2 = false;
            ClipboardManager it = clipboardManager2;
            boolean bl3 = false;
            it.setPrimaryClip(ClipData.newPlainText((CharSequence)text, (CharSequence)text));
            ContextExtensionsKt.longToast($this$copyToClipboard, R.string.copied_to_clipboard);
        }
    }

    public static final void shortToast(@NotNull Context $this$shortToast, @StringRes int text) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shortToast, (String)"$this$shortToast");
        Toast.makeText((Context)$this$shortToast, (int)text, (int)0).show();
    }

    public static final void shortToast(@NotNull Context $this$shortToast, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shortToast, (String)"$this$shortToast");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Toast.makeText((Context)$this$shortToast, (CharSequence)text, (int)0).show();
    }

    public static final void longToast(@NotNull Context $this$longToast, @StringRes int text) {
        Intrinsics.checkParameterIsNotNull((Object)$this$longToast, (String)"$this$longToast");
        Toast.makeText((Context)$this$longToast, (int)text, (int)1).show();
    }

    public static final void longToast(@NotNull Context $this$longToast, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)$this$longToast, (String)"$this$longToast");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Toast.makeText((Context)$this$longToast, (CharSequence)text, (int)1).show();
    }

    @Nullable
    public static final Boolean showKeyboard(@NotNull Context $this$showKeyboard, @NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)$this$showKeyboard, (String)"$this$showKeyboard");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Context $this$inputMethodManager$iv = $this$showKeyboard;
        boolean $i$f$getInputMethodManager = false;
        Object object = $this$inputMethodManager$iv.getSystemService("input_method");
        if (!(object instanceof InputMethodManager)) {
            object = null;
        }
        InputMethodManager inputMethodManager = (InputMethodManager)object;
        return inputMethodManager != null ? Boolean.valueOf(inputMethodManager.showSoftInput(view, 1)) : null;
    }

    @Nullable
    public static final Unit toggleKeyboard(@NotNull Context $this$toggleKeyboard) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)$this$toggleKeyboard, (String)"$this$toggleKeyboard");
        Context $this$inputMethodManager$iv = $this$toggleKeyboard;
        boolean $i$f$getInputMethodManager = false;
        Object object = $this$inputMethodManager$iv.getSystemService("input_method");
        if (!(object instanceof InputMethodManager)) {
            object = null;
        }
        InputMethodManager inputMethodManager = (InputMethodManager)object;
        if (inputMethodManager != null) {
            inputMethodManager.toggleSoftInput(1, 0);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @Nullable
    public static final Boolean hideKeyboard(@NotNull Context $this$hideKeyboard, @NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)$this$hideKeyboard, (String)"$this$hideKeyboard");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Context $this$inputMethodManager$iv = $this$hideKeyboard;
        boolean $i$f$getInputMethodManager = false;
        Object object = $this$inputMethodManager$iv.getSystemService("input_method");
        if (!(object instanceof InputMethodManager)) {
            object = null;
        }
        InputMethodManager inputMethodManager = (InputMethodManager)object;
        return inputMethodManager != null ? Boolean.valueOf(inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 2)) : null;
    }
}

