/*
 * Decompiled with CFR 0.152.
 */
package com.sybit.airtable;

import com.google.gson.annotations.SerializedName;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.GetRequest;
import com.sybit.airtable.Base;
import com.sybit.airtable.Query;
import com.sybit.airtable.Sort;
import com.sybit.airtable.exception.AirtableException;
import com.sybit.airtable.exception.HttpResponseExceptionHandler;
import com.sybit.airtable.vo.Attachment;
import com.sybit.airtable.vo.Delete;
import com.sybit.airtable.vo.PostRecord;
import com.sybit.airtable.vo.RecordItem;
import com.sybit.airtable.vo.Records;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.http.client.HttpResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Table<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Table.class);
    private static final String MIME_TYPE_JSON = "application/json";
    private static final String FIELD_ID = "id";
    private static final String FIELD_CREATED_TIME = "createdTime";
    private final String name;
    private final Class<T> type;
    private Base parent;

    public Table(String name, Class<T> type) {
        assert (name != null) : "name was null";
        assert (type != null) : "type was null";
        this.name = name;
        this.type = type;
    }

    public Table(String name, Class<T> type, Base base) {
        this(name, type);
        this.setParent(base);
    }

    public void setParent(Base parent) {
        this.parent = parent;
    }

    public List<T> select() throws AirtableException, HttpResponseException {
        return this.select(new Query(){

            @Override
            public Integer getMaxRecords() {
                return null;
            }

            @Override
            public String getView() {
                return null;
            }

            @Override
            public List<Sort> getSort() {
                return null;
            }

            @Override
            public String filterByFormula() {
                return null;
            }

            @Override
            public String[] getFields() {
                return null;
            }

            @Override
            public Integer getPageSize() {
                return null;
            }

            @Override
            public String getOffset() {
                return null;
            }
        });
    }

    public List<T> select(Query query) throws AirtableException {
        List<T> list;
        HttpResponse response;
        try {
            GetRequest request = Unirest.get((String)this.getTableEndpointUrl()).header("accept", MIME_TYPE_JSON).header("Authorization", this.getBearerToken()).header("Content-type", MIME_TYPE_JSON);
            if (query.getFields() != null && query.getFields().length > 0) {
                String[] fields = query.getFields();
                for (String field : fields) {
                    request.queryString("fields[]", (Object)field);
                }
            }
            if (query.getMaxRecords() != null) {
                request.queryString("maxRecords", (Object)query.getMaxRecords());
            }
            if (query.getView() != null) {
                request.queryString("view", (Object)query.getView());
            }
            if (query.filterByFormula() != null) {
                request.queryString("filterByFormula", (Object)query.filterByFormula());
            }
            if (query.getPageSize() != null) {
                if (query.getPageSize() > 100) {
                    LOG.warn("pageSize is limited to max 100 but was " + query.getPageSize());
                    request.queryString("pageSize", (Object)100);
                } else {
                    request.queryString("pageSize", (Object)query.getPageSize());
                }
            }
            if (query.getSort() != null) {
                int i = 0;
                for (Sort sort : query.getSort()) {
                    request.queryString("sort[" + i + "][field]", (Object)sort.getField());
                    request.queryString("sort[" + i + "][direction]", (Object)sort.getDirection());
                }
            }
            if (query.getOffset() != null) {
                request.queryString("offset", (Object)query.getOffset());
            }
            LOG.debug("URL=" + request.getUrl());
            response = request.asObject(Records.class);
        }
        catch (UnirestException e) {
            throw new AirtableException(e);
        }
        int code = response.getStatus();
        if (200 == code) {
            list = this.getList((HttpResponse<Records>)response);
            String offset = ((Records)response.getBody()).getOffset();
            if (offset != null) {
                list.addAll(this.select(query, offset));
            }
        } else {
            HttpResponseExceptionHandler.onResponse(response);
            list = null;
        }
        return list;
    }

    private List<T> select(final Query query, final String offset) throws AirtableException {
        return this.select(new Query(){

            @Override
            public Integer getMaxRecords() {
                return query.getMaxRecords();
            }

            @Override
            public String getView() {
                return query.getView();
            }

            @Override
            public List<Sort> getSort() {
                return query.getSort();
            }

            @Override
            public String filterByFormula() {
                return query.filterByFormula();
            }

            @Override
            public String[] getFields() {
                return query.getFields();
            }

            @Override
            public Integer getPageSize() {
                return query.getPageSize();
            }

            @Override
            public String getOffset() {
                return offset;
            }
        });
    }

    public List<T> select(final Integer maxRecords) throws AirtableException, HttpResponseException {
        return this.select(new Query(){

            @Override
            public Integer getMaxRecords() {
                return maxRecords;
            }

            @Override
            public String getView() {
                return null;
            }

            @Override
            public List<Sort> getSort() {
                return null;
            }

            @Override
            public String filterByFormula() {
                return null;
            }

            @Override
            public String[] getFields() {
                return null;
            }

            @Override
            public Integer getPageSize() {
                return null;
            }

            @Override
            public String getOffset() {
                return null;
            }
        });
    }

    public List<T> select(final String view) throws AirtableException, HttpResponseException {
        return this.select(new Query(){

            @Override
            public Integer getMaxRecords() {
                return null;
            }

            @Override
            public String getView() {
                return view;
            }

            @Override
            public List<Sort> getSort() {
                return null;
            }

            @Override
            public String filterByFormula() {
                return null;
            }

            @Override
            public String[] getFields() {
                return null;
            }

            @Override
            public Integer getPageSize() {
                return null;
            }

            @Override
            public String getOffset() {
                return null;
            }
        });
    }

    public List<T> select(Sort sortation) throws AirtableException, HttpResponseException {
        final ArrayList<Sort> sortList = new ArrayList<Sort>();
        sortList.add(sortation);
        return this.select(new Query(){

            @Override
            public Integer getMaxRecords() {
                return null;
            }

            @Override
            public String getView() {
                return null;
            }

            @Override
            public List<Sort> getSort() {
                return sortList;
            }

            @Override
            public String filterByFormula() {
                return null;
            }

            @Override
            public String[] getFields() {
                return null;
            }

            @Override
            public Integer getPageSize() {
                return null;
            }

            @Override
            public String getOffset() {
                return null;
            }
        });
    }

    public List<T> select(final String[] fields) throws AirtableException, HttpResponseException {
        return this.select(new Query(){

            @Override
            public Integer getMaxRecords() {
                return null;
            }

            @Override
            public String getView() {
                return null;
            }

            @Override
            public List<Sort> getSort() {
                return null;
            }

            @Override
            public String filterByFormula() {
                return null;
            }

            @Override
            public String[] getFields() {
                return fields;
            }

            @Override
            public Integer getPageSize() {
                return null;
            }

            @Override
            public String getOffset() {
                return null;
            }
        });
    }

    private List<T> getList(HttpResponse<Records> response) {
        Records records = (Records)response.getBody();
        ArrayList<Object> list = new ArrayList<Object>();
        for (Map<String, Object> record : records.getRecords()) {
            Object item = null;
            try {
                item = this.transform(record, this.type.newInstance());
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            list.add(item);
        }
        return list;
    }

    public T find(String id) throws AirtableException {
        RecordItem body;
        HttpResponse response;
        try {
            response = Unirest.get((String)(this.getTableEndpointUrl() + "/" + id)).header("accept", MIME_TYPE_JSON).header("Authorization", this.getBearerToken()).asObject(RecordItem.class);
        }
        catch (UnirestException e) {
            throw new AirtableException(e);
        }
        int code = response.getStatus();
        if (200 == code) {
            body = (RecordItem)response.getBody();
        } else {
            HttpResponseExceptionHandler.onResponse(response);
            body = null;
        }
        try {
            return this.transform(body, this.type.newInstance());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new AirtableException(e);
        }
    }

    public T create(T item) throws AirtableException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        HttpResponse response;
        RecordItem responseBody = null;
        this.checkProperties(item);
        PostRecord<T> body = new PostRecord<T>();
        body.setFields(item);
        try {
            response = Unirest.post((String)this.getTableEndpointUrl()).header("accept", MIME_TYPE_JSON).header("Authorization", this.getBearerToken()).header("Content-type", MIME_TYPE_JSON).body(body).asObject(RecordItem.class);
        }
        catch (UnirestException e) {
            throw new AirtableException(e);
        }
        int code = response.getStatus();
        if (200 == code) {
            responseBody = (RecordItem)response.getBody();
        } else {
            HttpResponseExceptionHandler.onResponse(response);
        }
        try {
            return this.transform(responseBody, this.type.newInstance());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public T update(T item) throws AirtableException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        T result;
        HttpResponse response;
        RecordItem responseBody = null;
        String id = this.getIdOfItem(item);
        PostRecord<T> body = new PostRecord<T>();
        body.setFields(this.filterFields(item));
        try {
            response = Unirest.patch((String)(this.getTableEndpointUrl() + "/" + id)).header("accept", MIME_TYPE_JSON).header("Authorization", this.getBearerToken()).header("Content-type", MIME_TYPE_JSON).body(body).asObject(RecordItem.class);
        }
        catch (UnirestException e) {
            throw new AirtableException(e);
        }
        int code = response.getStatus();
        if (200 == code) {
            responseBody = (RecordItem)response.getBody();
        } else {
            HttpResponseExceptionHandler.onResponse(response);
        }
        try {
            result = this.transform(responseBody, this.type.newInstance());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            result = null;
        }
        return result;
    }

    public T replace(T item) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public boolean destroy(String id) throws AirtableException {
        boolean isDeleted;
        HttpResponse response;
        try {
            response = Unirest.delete((String)(this.getTableEndpointUrl() + "/" + id)).header("accept", MIME_TYPE_JSON).header("Authorization", this.getBearerToken()).asObject(Delete.class);
        }
        catch (UnirestException e) {
            throw new AirtableException(e);
        }
        int code = response.getStatus();
        if (200 == code) {
            Delete body = (Delete)response.getBody();
            isDeleted = body.isDeleted();
        } else {
            isDeleted = false;
            HttpResponseExceptionHandler.onResponse(response);
        }
        return isDeleted;
    }

    private Base base() {
        return this.parent;
    }

    private String getTableEndpointUrl() {
        return this.base().airtable().endpointUrl() + "/" + this.base().name() + "/" + this.name;
    }

    private String getBearerToken() {
        return "Bearer " + this.base().airtable().apiKey();
    }

    private T transform(Map<String, Object> record, T retval) throws InvocationTargetException, IllegalAccessException {
        for (String key : record.keySet()) {
            if ("fields".equals(key)) {
                retval = this.transform((Map)record.get("fields"), retval);
                continue;
            }
            this.setProperty(retval, key, record.get(key));
        }
        return retval;
    }

    private T transform(RecordItem record, T retval) throws InvocationTargetException, IllegalAccessException {
        this.setProperty(retval, FIELD_ID, record.getId());
        this.setProperty(retval, FIELD_CREATED_TIME, record.getCreatedTime());
        retval = this.transform(record.getFields(), retval);
        return retval;
    }

    private void setProperty(T retval, String key, Object value) throws IllegalAccessException, InvocationTargetException {
        String property = this.key2property(key);
        for (Field f : this.type.getDeclaredFields()) {
            SerializedName annotation = f.getAnnotation(SerializedName.class);
            if (annotation == null || !property.equalsIgnoreCase(annotation.value())) continue;
            property = f.getName();
            break;
        }
        if (Table.propertyExists(retval, property)) {
            BeanUtils.setProperty(retval, (String)property, (Object)value);
        } else {
            LOG.warn(retval.getClass() + " does not support public setter for existing property [" + property + "]");
        }
    }

    String key2property(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key was null or empty.");
        }
        if (key.contains(" ") || key.contains("-")) {
            LOG.warn("Annotate columns having special characters by using @SerializedName for property: [" + key + "]");
        }
        String property = key.trim();
        property = property.substring(0, 1).toLowerCase() + property.substring(1, property.length());
        return property;
    }

    private static boolean propertyExists(Object bean, String property) {
        return PropertyUtils.isReadable((Object)bean, (String)property) && PropertyUtils.isWriteable((Object)bean, (String)property);
    }

    private void checkProperties(T item) throws AirtableException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (Table.propertyExists(item, FIELD_ID) || Table.propertyExists(item, FIELD_CREATED_TIME)) {
            Field[] attributes;
            for (Field attribute : attributes = item.getClass().getDeclaredFields()) {
                String attrName = attribute.getName();
                if (FIELD_ID.equals(attrName) || FIELD_CREATED_TIME.equals(attrName)) {
                    if (BeanUtils.getProperty(item, (String)attribute.getName()) == null) continue;
                    throw new AirtableException("Property " + attrName + " should be null!");
                }
                if (!"photos".equals(attrName)) continue;
                List obj = (List)BeanUtilsBean.getInstance().getPropertyUtils().getProperty(item, "photos");
                this.checkPropertiesOfAttachement(obj);
            }
        }
    }

    private void checkPropertiesOfAttachement(List<Attachment> attachements) throws AirtableException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (attachements != null) {
            for (int i = 0; i < attachements.size(); ++i) {
                Field[] attributesPhotos;
                if (!Table.propertyExists(attachements.get(i), FIELD_ID) && !Table.propertyExists(attachements.get(i), "size") && !Table.propertyExists(attachements.get(i), "type") && !Table.propertyExists(attachements.get(i), "filename")) continue;
                for (Field attributePhoto : attributesPhotos = attachements.getClass().getDeclaredFields()) {
                    String namePhotoAttribute = attributePhoto.getName();
                    if (!FIELD_ID.equals(namePhotoAttribute) && !"size".equals(namePhotoAttribute) && !"type".equals(namePhotoAttribute) && !"filename".equals(namePhotoAttribute) || BeanUtils.getProperty((Object)attachements.get(i), (String)namePhotoAttribute) == null) continue;
                    throw new AirtableException("Property " + namePhotoAttribute + " should be null!");
                }
            }
        }
    }

    private String getIdOfItem(T item) throws AirtableException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String id;
        if (Table.propertyExists(item, FIELD_ID) && (id = BeanUtils.getProperty(item, (String)FIELD_ID)) != null) {
            return id;
        }
        throw new AirtableException("Id of " + item + " not Found!");
    }

    private T filterFields(T item) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Field[] attributes;
        for (Field attribute : attributes = item.getClass().getDeclaredFields()) {
            String attrName = attribute.getName();
            if (!FIELD_ID.equals(attrName) && !FIELD_CREATED_TIME.equals(attrName) || BeanUtils.getProperty(item, (String)attrName) == null) continue;
            BeanUtilsBean.getInstance().getPropertyUtils().setProperty(item, attrName, null);
        }
        return item;
    }
}

