/*
 * Decompiled with CFR 0.152.
 */
package com.sybit.airtable;

import com.sybit.airtable.Airtable;
import com.sybit.airtable.Table;
import com.sybit.airtable.vo.Records;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base {
    private static final Logger LOG = LoggerFactory.getLogger(Base.class);
    private final Map<String, Table> tableMap = new HashMap<String, Table>();
    private final String baseName;
    private final Airtable parent;

    public Base(String name, Airtable airtable) {
        assert (name != null) : "baseName was null";
        assert (airtable != null) : "airtable was null";
        this.baseName = name;
        this.parent = airtable;
    }

    public Airtable airtable() {
        return this.parent;
    }

    public Table table(String name) {
        return this.table(name, Records.class);
    }

    public Table table(String name, Class clazz) {
        assert (name != null) : "name was null";
        assert (clazz != null) : "clazz was null";
        if (!this.tableMap.containsKey(name)) {
            LOG.debug("Create new instance for table [" + name + "]");
            Table t = new Table(name, clazz);
            t.setParent(this);
            this.tableMap.put(name, t);
        }
        return this.tableMap.get(name);
    }

    public String name() {
        return this.baseName;
    }
}

